/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render;

import gaiasky.util.Bits;
import gaiasky.util.i18n.I18n;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

public class ComponentTypes
extends Bits {
    public static final int CT_SIZE = 32;

    public ComponentTypes() {
        super(32);
    }

    public ComponentTypes(int ordinal) {
        super(32);
        this.set(ordinal);
    }

    public ComponentTypes(ComponentType ... cts) {
        for (ComponentType ct : cts) {
            this.set(ct.ordinal());
        }
    }

    public int getFirstOrdinal() {
        return this.nextSetBit(0);
    }

    public boolean allSetLike(ComponentTypes other) {
        return other.containsAll(this);
    }

    public boolean isEnabled(ComponentType ct) {
        return this.get(ct.ordinal());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isEmpty()) {
            return "Empty";
        }
        ComponentType[] values = ComponentType.values();
        int i = this.nextSetBit(0);
        while (i >= 0) {
            sb.append((Object)values[i]).append(" ");
            i = this.nextSetBit(i + 1);
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        return sb.toString();
    }

    public static enum ComponentType {
        Stars("icon-elem-stars"),
        Planets("icon-elem-planets"),
        Moons("icon-elem-moons"),
        Satellites("icon-elem-satellites"),
        Asteroids("icon-elem-asteroids"),
        Clusters("icon-elem-clusters"),
        MilkyWay("icon-elem-milkyway"),
        Galaxies("icon-elem-galaxies"),
        Nebulae("icon-elem-nebulae"),
        Meshes("icon-elem-meshes"),
        Systems("icon-elem-systems"),
        Labels("icon-elem-labels"),
        Orbits("icon-elem-orbits"),
        Locations("icon-elem-locations"),
        Countries("icon-elem-countries"),
        Ruler("icon-elem-ruler"),
        Equatorial("icon-elem-equatorial"),
        Ecliptic("icon-elem-ecliptic"),
        Galactic("icon-elem-galactic"),
        RecursiveGrid("icon-elem-recgrid"),
        Constellations("icon-elem-constellations"),
        Boundaries("icon-elem-boundaries"),
        Atmospheres("icon-elem-atmospheres"),
        Clouds("icon-elem-clouds"),
        Effects("icon-elem-effects"),
        Axes("icon-elem-axes"),
        VelocityVectors("icon-elem-arrows"),
        Keyframes("icon-elem-keyframes"),
        Others("icon-elem-others"),
        Invisible(null);

        private static final Map<String, ComponentType> keysMap;
        public final String key = "element." + this.name().toLowerCase(Locale.ROOT);
        public final String style;

        private ComponentType(String icon) {
            this.style = icon;
        }

        public static ComponentType getFromKey(String key) {
            return keysMap.get(key);
        }

        public String getName() {
            try {
                return I18n.msg(this.key);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }

        public String toString() {
            return super.toString();
        }

        static {
            keysMap = new HashMap<String, ComponentType>();
            for (ComponentType ct : ComponentType.values()) {
                keysMap.put(ct.key, ct);
            }
        }
    }
}

