/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render;

import gaiasky.util.Logger;
import gaiasky.util.SysUtils;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.TessellationShaderProgram;
import gaiasky.util.i18n.I18n;

public class GaiaSkyShaderCompileException
extends RuntimeException {
    private final Logger.Log logger = Logger.getLogger(GaiaSkyShaderCompileException.class);

    public GaiaSkyShaderCompileException(ExtShaderProgram program) {
        super(GaiaSkyShaderCompileException.getMessage(program));
        this.writeShader(program.getVertexShaderFileName(), program.getVertexShaderSource());
        this.writeShader(program.getGeometryShaderFileName(), program.getGeometryShaderSource());
        this.writeShader(program.getFragmentShaderFileName(), program.getFragmentShaderSource());
        if (program instanceof TessellationShaderProgram) {
            TessellationShaderProgram tessProgram = (TessellationShaderProgram)program;
            this.writeShader(tessProgram.getControlShaderFileName(), tessProgram.getControlShaderSource());
            this.writeShader(tessProgram.getEvaluationShaderFileName(), tessProgram.getEvaluationShaderSource());
        }
    }

    private static String getMessage(ExtShaderProgram program) {
        String nl = System.lineSeparator();
        StringBuilder buff = new StringBuilder();
        if (program.getName() == null || program.getName().isEmpty()) {
            buff.append(I18n.msg("notif.shader.compile.fail")).append(nl);
        } else {
            buff.append(I18n.msg("notif.shader.compile.fail")).append(":: ").append(program.getName()).append(nl);
        }
        if (program.getVertexShaderFileName() != null) {
            buff.append(I18n.msg("notif.shader.vertex", program.getVertexShaderFileName())).append(nl);
        }
        if (program instanceof TessellationShaderProgram) {
            TessellationShaderProgram tessProgram = (TessellationShaderProgram)program;
            if (tessProgram.getControlShaderFileName() != null) {
                buff.append(I18n.msg("notif.shader.tessellation.control", tessProgram.getControlShaderFileName())).append(nl);
            }
            if (tessProgram.getEvaluationShaderFileName() != null) {
                buff.append(I18n.msg("notif.shader.tessellation.evaluation", tessProgram.getEvaluationShaderFileName())).append(nl);
            }
        }
        if (program.getGeometryShaderFileName() != null) {
            buff.append(I18n.msg("notif.shader.geometry", program.getGeometryShaderFileName())).append(nl);
        }
        if (program.getFragmentShaderFileName() != null) {
            buff.append(I18n.msg("notif.shader.fragment", program.getFragmentShaderFileName())).append(nl);
        }
        buff.append(program.getLog()).append(nl);
        buff.append("Full shaders saved to ").append(SysUtils.getCrashShadersDir()).append(nl);
        return buff.toString();
    }

    private void writeShader(String name, String code) {
        ExtShaderProgram.writeShader(name, code);
    }
}

