/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Timer;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.api.IPostProcessor;
import gaiasky.render.postprocess.PostProcessor;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.effects.Antialiasing;
import gaiasky.render.postprocess.effects.Blend;
import gaiasky.render.postprocess.effects.Bloom;
import gaiasky.render.postprocess.effects.CameraMotionBlur;
import gaiasky.render.postprocess.effects.ChromaticAberration;
import gaiasky.render.postprocess.effects.Curvature;
import gaiasky.render.postprocess.effects.FilmGrain;
import gaiasky.render.postprocess.effects.Fxaa;
import gaiasky.render.postprocess.effects.LensFlare;
import gaiasky.render.postprocess.effects.Levels;
import gaiasky.render.postprocess.effects.LightGlow;
import gaiasky.render.postprocess.effects.Nfaa;
import gaiasky.render.postprocess.effects.PseudoLensFlare;
import gaiasky.render.postprocess.effects.RaymarchObject;
import gaiasky.render.postprocess.effects.Reprojection;
import gaiasky.render.postprocess.effects.SSR;
import gaiasky.render.postprocess.effects.UnsharpMask;
import gaiasky.render.postprocess.effects.WarpingMesh;
import gaiasky.render.postprocess.effects.XBRZ;
import gaiasky.render.util.ShaderLoader;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Raymarching;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SlaveManager;
import gaiasky.util.SysUtils;
import gaiasky.util.gdx.loader.PFMData;
import gaiasky.util.gdx.loader.PFMReader;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3Q;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import net.jafama.FastMath;

public class MainPostProcessor
implements IPostProcessor,
IObserver {
    private static final Logger.Log logger = Logger.getLogger(MainPostProcessor.class);
    private final Map<String, Object[]> rayMarchingDefinitions;
    float ar;
    FocusView focusView;
    private AssetManager manager;
    private IPostProcessor.PostProcessBean[] pps;
    private Scene scene;
    private String starLensTextureName;
    private String lensDirtName;
    private String lensColorName;
    private String lensStarburstName;
    final Vector3Q v3b1 = new Vector3Q();
    final Vector3Q v3b2 = new Vector3Q();
    final Vector3 v3f1 = new Vector3();
    final Matrix4 prevViewProj = new Matrix4();
    final Matrix4 projection = new Matrix4();
    final Matrix4 combined = new Matrix4();
    final Matrix4 view = new Matrix4();
    final Matrix4 frustumCorners = new Matrix4();

    public MainPostProcessor(Scene scene) {
        ShaderLoader.BasePath = "shader/postprocess/";
        this.scene = scene;
        this.focusView = new FocusView();
        this.rayMarchingDefinitions = new HashMap<String, Object[]>();
        EventManager.instance.subscribe((IObserver)this, Event.RAYMARCHING_CMD);
    }

    private void addRayMarchingDef(String name, Object[] list) {
        if (!this.rayMarchingDefinitions.containsKey(name)) {
            this.rayMarchingDefinitions.put(name, list);
        }
    }

    @Override
    public void initialize(AssetManager manager) {
        this.manager = manager;
        logger.info(I18n.msg("notif.postproc.init"));
        Settings.PostprocessSettings.LensFlareSettings settings = Settings.settings.postprocess.lensFlare;
        this.lensDirtName = Settings.settings.data.dataFile(GlobalResources.unpackAssetPath(settings.texLensDirt));
        this.lensColorName = Settings.settings.data.dataFile(settings.texLensColor);
        this.lensStarburstName = Settings.settings.data.dataFile(settings.texLensStarburst);
        this.starLensTextureName = Settings.settings.scene.star.getStarLensTexture();
        manager.load(this.starLensTextureName, Texture.class);
        manager.load(this.lensDirtName, Texture.class);
        manager.load(this.lensColorName, Texture.class);
        manager.load(this.lensStarburstName, Texture.class);
    }

    @Override
    public void doneLoading(AssetManager manager) {
        this.pps = new IPostProcessor.PostProcessBean[IPostProcessor.RenderType.values().length];
        EventManager.instance.subscribe((IObserver)this, Event.SCREENSHOT_SIZE_UPDATE, Event.FRAME_SIZE_UPDATE, Event.BLOOM_CMD, Event.UNSHARP_MASK_CMD, Event.LENS_FLARE_CMD, Event.SSR_CMD, Event.MOTION_BLUR_CMD, Event.LIGHT_POS_2D_UPDATE, Event.LIGHT_GLOW_CMD, Event.REPROJECTION_CMD, Event.CUBEMAP_CMD, Event.ANTIALIASING_CMD, Event.BRIGHTNESS_CMD, Event.CONTRAST_CMD, Event.HUE_CMD, Event.SATURATION_CMD, Event.GAMMA_CMD, Event.TONEMAPPING_TYPE_CMD, Event.EXPOSURE_CMD, Event.STEREO_PROFILE_CMD, Event.STEREOSCOPIC_CMD, Event.FOV_CHANGED_CMD, Event.STAR_BRIGHTNESS_CMD, Event.STAR_GLOW_FACTOR_CMD, Event.STAR_POINT_SIZE_CMD, Event.CAMERA_MOTION_UPDATE, Event.CAMERA_ORIENTATION_UPDATE, Event.BILLBOARD_TEXTURE_IDX_CMD, Event.SCENE_LOADED, Event.INDEXOFREFRACTION_CMD, Event.BACKBUFFER_SCALE_CMD, Event.UPSCALE_FILTER_CMD, Event.CHROMATIC_ABERRATION_CMD, Event.FILM_GRAIN_CMD, Event.SHADER_RELOAD_CMD);
    }

    public void initializeOffScreenPostProcessors() {
        int[] screenshot = this.getSize(IPostProcessor.RenderType.screenshot);
        int[] frame = this.getSize(IPostProcessor.RenderType.frame);
        this.pps[IPostProcessor.RenderType.screenshot.index] = this.newPostProcessor(IPostProcessor.RenderType.screenshot, screenshot[0], screenshot[1], screenshot[0], screenshot[1], this.manager);
        this.pps[IPostProcessor.RenderType.frame.index] = this.newPostProcessor(IPostProcessor.RenderType.frame, frame[0], frame[1], frame[0], frame[1], this.manager);
    }

    private int[] getSize(IPostProcessor.RenderType type) {
        int[] nArray;
        switch (type) {
            default: {
                throw new MatchException(null, null);
            }
            case screen: {
                int[] nArray2 = new int[2];
                nArray2[0] = (int)FastMath.round((double)((double)Settings.settings.graphics.resolution[0] * Settings.settings.graphics.backBufferScale));
                nArray = nArray2;
                nArray2[1] = (int)FastMath.round((double)((double)Settings.settings.graphics.resolution[1] * Settings.settings.graphics.backBufferScale));
                break;
            }
            case screenshot: {
                int[] nArray3 = new int[2];
                nArray3[0] = Settings.settings.screenshot.resolution[0];
                nArray = nArray3;
                nArray3[1] = Settings.settings.screenshot.resolution[1];
                break;
            }
            case frame: {
                int[] nArray4 = new int[2];
                nArray4[0] = Settings.settings.frame.resolution[0];
                nArray = nArray4;
                nArray4[1] = Settings.settings.frame.resolution[1];
            }
        }
        return nArray;
    }

    private IPostProcessor.PostProcessBean newPostProcessor(IPostProcessor.RenderType rt, float width, float height, float targetWidth, float targetHeight, AssetManager manager) {
        final IPostProcessor.PostProcessBean ppb = new IPostProcessor.PostProcessBean();
        Settings settings = Settings.settings;
        Settings.SceneSettings.StarSettings ss = settings.scene.star;
        boolean safeMode = settings.program.safeMode;
        boolean vr = settings.runtime.openXr;
        this.ar = width / height;
        ppb.pp = new PostProcessor(rt, FastMath.round((float)width), FastMath.round((float)height), true, true, false, !safeMode, !safeMode, safeMode);
        ppb.pp.setViewport(new Rectangle(0.0f, 0.0f, targetWidth, targetHeight));
        final Settings.PostprocessSettings.LightGlowSettings glowSettings = Settings.settings.postprocess.lightGlow;
        Texture glow = (Texture)manager.get(this.starLensTextureName);
        glow.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        LightGlow lightGlow = new LightGlow((int)width, (int)height);
        lightGlow.setLightGlowTexture(glow);
        lightGlow.setTextureScale(this.getGlowTextureScale(ss.brightness, ss.glowFactor, ss.pointSize, GaiaSky.instance.cameraManager.getFovFactor(), settings.program.modeCubemap.active));
        lightGlow.setSpiralScale(this.getGlowSpiralScale(ss.brightness, ss.pointSize, GaiaSky.instance.cameraManager.getFovFactor()));
        lightGlow.setBackBufferScale(settings.runtime.openXr ? (float)settings.graphics.backBufferScale : 1.0f);
        lightGlow.setEnabled(!SysUtils.isMac() && glowSettings.active);
        lightGlow.setEnabledOptions(true, true);
        ppb.add(lightGlow);
        this.updateGlow(ppb, settings.graphics.quality);
        this.rayMarchingDefinitions.forEach((key, list) -> {
            RaymarchObject rm = new RaymarchObject((String)list[0], width, height);
            float zFar = (float)GaiaSky.instance.getCameraManager().current.getFar();
            float k = Constants.getCameraK();
            Entity entity = (Entity)list[2];
            Body body = (Body)Mapper.body.get(entity);
            Raymarching raymarching = (Raymarching)Mapper.raymarching.get(entity);
            rm.setSize(body.size * 0.1f);
            rm.setZfarK(zFar, k);
            if (((Object[])list).length > 3 && list[3] != null) {
                rm.setAdditional((float[])list[3]);
            }
            if (((Object[])list).length > 4) {
                try {
                    Texture tex = (Texture)list[4];
                    rm.setAdditionalTexture(tex);
                }
                catch (Exception e) {
                    logger.error(e);
                }
            }
            rm.setEnabled(raymarching.isOn);
            ppb.add((String)key, rm);
        });
        SSR ssrEffect = new SSR();
        ssrEffect.setZfarK((float)GaiaSky.instance.getCameraManager().current.getFar(), Constants.getCameraK());
        ssrEffect.setEnabled(settings.postprocess.ssr.active && !vr && !safeMode);
        ppb.add(ssrEffect);
        CameraMotionBlur cameraMotionBlur = new CameraMotionBlur(width, height);
        cameraMotionBlur.setBlurScale(Settings.settings.postprocess.motionBlur.strength);
        cameraMotionBlur.setEnabled(settings.postprocess.motionBlur.active && !vr && !safeMode);
        cameraMotionBlur.setEnabledOptions(false, false);
        ppb.add(cameraMotionBlur);
        this.updateCameraBlur(ppb);
        if (SysUtils.isMac() && glowSettings.active) {
            Timer.Task enableLG = new Timer.Task(this){

                public void run() {
                    logger.info("Enabling light glow effect...");
                    ppb.get(LightGlow.class).setEnabled(glowSettings.active);
                }
            };
            Timer.schedule((Timer.Task)enableLG, (float)5.0f);
        }
        Settings.PostprocessSettings.LensFlareSettings lensFlareSettings = settings.postprocess.lensFlare;
        if (lensFlareSettings.type.isPseudoLensFlare()) {
            Texture lensColor = (Texture)manager.get(this.lensColorName);
            lensColor.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Texture lensDirt = (Texture)manager.get(this.lensDirtName);
            lensDirt.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Texture lensStarBurst = (Texture)manager.get(this.lensStarburstName);
            lensStarBurst.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            PseudoLensFlare pseudoLensFlare = new PseudoLensFlare((int)(width * lensFlareSettings.fboScale), (int)(height * lensFlareSettings.fboScale));
            pseudoLensFlare.setGhosts(lensFlareSettings.numGhosts);
            pseudoLensFlare.setHaloWidth(lensFlareSettings.haloWidth);
            pseudoLensFlare.setLensColorTexture(lensColor);
            pseudoLensFlare.setLensDirtTexture(lensDirt);
            pseudoLensFlare.setLensStarburstTexture(lensStarBurst);
            pseudoLensFlare.setFlareIntensity(lensFlareSettings.active ? lensFlareSettings.strength * 0.15f : 0.0f);
            pseudoLensFlare.setFlareSaturation(lensFlareSettings.flareSaturation);
            pseudoLensFlare.setBaseIntensity(1.0f);
            pseudoLensFlare.setBias(lensFlareSettings.bias);
            pseudoLensFlare.setBlurPasses(lensFlareSettings.blurPasses);
            pseudoLensFlare.setEnabledOptions(false, true);
            ppb.add(pseudoLensFlare);
        } else {
            Texture lensDirt = (Texture)manager.get(this.lensDirtName);
            lensDirt.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Texture lensStarBurst = (Texture)manager.get(this.lensStarburstName);
            lensStarBurst.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            LensFlare lensFlare = new LensFlare((int)(width * lensFlareSettings.fboScale), (int)(height * lensFlareSettings.fboScale), lensFlareSettings.strength, lensFlareSettings.type.ordinal(), true);
            lensFlare.setColor(new float[]{1.0f, 1.0f, 1.0f});
            lensFlare.setLensDirtTexture(lensDirt);
            lensFlare.setLensStarburstTexture(lensStarBurst);
            lensFlare.setEnabled(lensFlareSettings.active);
            lensFlare.setEnabledOptions(false, true);
            ppb.add(lensFlare);
        }
        Blend blend = new Blend();
        blend.setEnabled(true);
        ppb.add(blend);
        UnsharpMask unsharp = new UnsharpMask();
        unsharp.setSharpenFactor(settings.postprocess.unsharpMask.factor);
        unsharp.setEnabled(settings.postprocess.unsharpMask.factor > 0.0f);
        ppb.add(unsharp);
        this.initAntiAliasing(settings.postprocess.antialiasing.type, width, height, ppb);
        Bloom bloom = new Bloom((int)(width * settings.postprocess.bloom.fboScale), (int)(height * settings.postprocess.bloom.fboScale));
        bloom.setBloomIntesnity(settings.postprocess.bloom.intensity);
        bloom.setBlurPasses(10);
        bloom.setBlurAmount(0.0f);
        bloom.setBloomSaturation(0.7f);
        bloom.setThreshold(0.3f);
        bloom.setEnabled(settings.postprocess.bloom.intensity > 0.0f);
        ppb.add(bloom);
        Curvature curvature = new Curvature();
        curvature.setDistortion(1.2f);
        curvature.setZoom(0.75f);
        curvature.setEnabled(settings.program.modeStereo.active && settings.program.modeStereo.profile == Settings.StereoProfile.VR_HEADSET);
        curvature.setEnabledOptions(false, false);
        ppb.add(curvature);
        Reprojection reprojection = new Reprojection(width, height);
        reprojection.setFov(GaiaSky.instance.cameraManager.getCamera().fieldOfView);
        reprojection.setMode(settings.postprocess.reprojection.mode.mode);
        reprojection.setEnabled(settings.postprocess.reprojection.active);
        reprojection.setEnabledOptions(false, false);
        ppb.add(reprojection);
        FilmGrain grain = new FilmGrain(settings.postprocess.filmGrain.intensity);
        grain.setEnabledOptions(false, false);
        grain.setEnabled(settings.postprocess.filmGrain.intensity != 0.0f);
        ppb.add(grain);
        float amount = Settings.settings.postprocess.chromaticAberration.amount * GaiaSky.instance.cameraManager.getFovFactor();
        ChromaticAberration aberration = new ChromaticAberration(amount);
        aberration.setEnabledOptions(false, false);
        aberration.setEnabled(amount > 0.0f);
        ppb.add(aberration);
        this.initLevels(ppb);
        if (settings.program.net.isSlaveInstance() && SlaveManager.projectionActive() && SlaveManager.instance.isWarpOrBlend()) {
            WarpingMesh warpingMesh;
            Path warpFile = SlaveManager.instance.pfm;
            Path blendFile = SlaveManager.instance.blend;
            PFMData data = warpFile != null ? (PFMData)manager.get(warpFile.toString()) : PFMReader.constructPFMData(50, 50, x -> x, y -> y);
            if (blendFile != null) {
                Texture blendTex = (Texture)manager.get(blendFile.toString());
                warpingMesh = new WarpingMesh(data, blendTex);
            } else {
                warpingMesh = new WarpingMesh(data, width, height);
            }
            warpingMesh.setEnabled(true);
            warpingMesh.setEnabledOptions(false, false);
            ppb.add(warpingMesh);
        }
        if (settings.postprocess.warpingMesh != null && settings.postprocess.warpingMesh.pfmFile != null) {
            Path path = Path.of(settings.postprocess.warpingMesh.pfmFile, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                PFMData data = PFMReader.readPFMData(Gdx.files.absolute(path.toAbsolutePath().toString()), false, false);
                WarpingMesh warpingMesh = new WarpingMesh(data, width, height);
                warpingMesh.setEnabled(true);
                warpingMesh.setEnabledOptions(false, false);
                ppb.add(warpingMesh);
            } else {
                logger.error("Warping mesh PFM file does not exist: " + settings.postprocess.warpingMesh.pfmFile);
            }
        }
        if (rt == IPostProcessor.RenderType.screen) {
            XBRZ upscaleFilter = new XBRZ();
            ppb.add(upscaleFilter);
            this.updateUpscaleFilter(settings.postprocess.upscaleFilter, settings.graphics.backBufferScale, upscaleFilter, ppb);
        }
        return ppb;
    }

    private void updateGlow(IPostProcessor.PostProcessBean ppb, Settings.GraphicsQuality gq) {
        int lgw = gq.isUltra() ? 1920 : (gq.isHigh() ? 1500 : (gq.isNormal() ? 1280 : 1000));
        int lgh = FastMath.round((float)((float)lgw / this.ar));
        LightGlow lightglow = (LightGlow)ppb.get(LightGlow.class);
        if (lightglow != null) {
            lightglow.setNSamples(1);
            lightglow.setViewportSize(lgw, lgh);
        }
        Settings.settings.postprocess.lightGlow.samples = 1;
    }

    private void updateCameraBlur(IPostProcessor.PostProcessBean ppb) {
        CameraMotionBlur cameraMotionBlur = (CameraMotionBlur)ppb.get(CameraMotionBlur.class);
        if (cameraMotionBlur != null) {
            cameraMotionBlur.setBlurMaxSamples(35);
        }
    }

    private void initLevels(IPostProcessor.PostProcessBean ppb) {
        Levels levels = new Levels();
        levels.setBrightness(Settings.settings.postprocess.levels.brightness);
        levels.setContrast(Settings.settings.postprocess.levels.contrast);
        levels.setHue(Settings.settings.postprocess.levels.hue);
        levels.setSaturation(Settings.settings.postprocess.levels.saturation);
        levels.setGamma(Settings.settings.postprocess.levels.gamma);
        switch (Settings.settings.postprocess.toneMapping.type) {
            case AUTO: {
                levels.enableToneMappingAuto();
                break;
            }
            case EXPOSURE: {
                levels.enableToneMappingExposure();
                levels.setExposure(Settings.settings.postprocess.toneMapping.exposure);
                break;
            }
            case ACES: {
                levels.enableToneMappingACES();
                break;
            }
            case UNCHARTED: {
                levels.enableToneMappingUncharted();
                break;
            }
            case FILMIC: {
                levels.enableToneMappingFilmic();
                break;
            }
            case NONE: {
                levels.disableToneMapping();
            }
        }
        ppb.add(levels);
    }

    private void initAntiAliasing(Settings.PostprocessSettings.AntialiasType aavalue, float width, float height, IPostProcessor.PostProcessBean ppb) {
        Antialiasing antialiasing = null;
        if (aavalue.equals((Object)Settings.PostprocessSettings.AntialiasType.FXAA)) {
            antialiasing = new Fxaa(width, height, Settings.settings.postprocess.antialiasing.quality);
            Logger.getLogger(this.getClass()).debug(I18n.msg("notif.selected", "FXAA"));
        } else if (aavalue.equals((Object)Settings.PostprocessSettings.AntialiasType.NFAA)) {
            antialiasing = new Nfaa(width, height);
            Logger.getLogger(this.getClass()).debug(I18n.msg("notif.selected", "NFAA"));
        }
        if (antialiasing != null) {
            antialiasing.setEnabled(Settings.settings.postprocess.antialiasing.type.isPostProcessAntialias());
            ppb.add(antialiasing);
        }
    }

    @Override
    public IPostProcessor.PostProcessBean getPostProcessBean(IPostProcessor.RenderType type) {
        return this.pps[type.index];
    }

    @Override
    public void resize(int width, int height, int targetWidth, int targetHeight) {
        GaiaSky.postRunnable(() -> this.resizeImmediate(width, height, targetWidth, targetHeight));
    }

    @Override
    public void resizeImmediate(int width, int height, int targetWidth, int targetHeight) {
        this.replace(IPostProcessor.RenderType.screen, width, height, targetWidth, targetHeight);
    }

    public void dispose() {
        if (this.pps != null) {
            for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                if (this.pps[i] == null) continue;
                IPostProcessor.PostProcessBean ppb = this.pps[i];
                ppb.dispose();
            }
        }
    }

    private float getGlowTextureScale(double starBrightness, double glowFactor, float pointSize, float fovFactor, boolean cubemap) {
        glowFactor /= (double)0.06f;
        if (cubemap) {
            float ts = (float)starBrightness * (float)glowFactor * pointSize * 0.07f / fovFactor;
            return FastMath.min((float)(ts * 0.2f), (float)0.5f);
        }
        return (float)starBrightness * (float)glowFactor * 0.2f;
    }

    private float getGlowSpiralScale(double starBrightness, float starSize, float fovFactor) {
        return (float)starBrightness * starSize * 5.0E-5f / fovFactor;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case SCENE_LOADED: {
                this.scene = (Scene)data[0];
                this.initializeOffScreenPostProcessors();
                break;
            }
            case STAR_BRIGHTNESS_CMD: {
                Float brightness = (Float)data[0];
                GaiaSky.postRunnable(() -> {
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        IPostProcessor.PostProcessBean ppb;
                        LightGlow lightglow;
                        if (this.pps[i] == null || (lightglow = (LightGlow)(ppb = this.pps[i]).get(LightGlow.class)) == null) continue;
                        lightglow.setTextureScale(this.getGlowTextureScale(brightness.floatValue(), Settings.settings.scene.star.glowFactor, Settings.settings.scene.star.pointSize, GaiaSky.instance.cameraManager.getFovFactor(), Settings.settings.program.modeCubemap.active));
                        lightglow.setSpiralScale(this.getGlowSpiralScale(brightness.floatValue(), Settings.settings.scene.star.pointSize, GaiaSky.instance.cameraManager.getFovFactor()));
                    }
                });
                break;
            }
            case STAR_GLOW_FACTOR_CMD: {
                Float glowFactor = (Float)data[0];
                GaiaSky.postRunnable(() -> {
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        IPostProcessor.PostProcessBean ppb;
                        LightGlow lightglow;
                        if (this.pps[i] == null || (lightglow = (LightGlow)(ppb = this.pps[i]).get(LightGlow.class)) == null) continue;
                        lightglow.setTextureScale(this.getGlowTextureScale(Settings.settings.scene.star.brightness, glowFactor.floatValue(), Settings.settings.scene.star.pointSize, GaiaSky.instance.cameraManager.getFovFactor(), Settings.settings.program.modeCubemap.active));
                    }
                });
                break;
            }
            case STAR_POINT_SIZE_CMD: {
                Float size = (Float)data[0];
                GaiaSky.postRunnable(() -> {
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        IPostProcessor.PostProcessBean ppb;
                        LightGlow lightglow;
                        if (this.pps[i] == null || (lightglow = (LightGlow)(ppb = this.pps[i]).get(LightGlow.class)) == null) continue;
                        lightglow.setTextureScale(this.getGlowTextureScale(Settings.settings.scene.star.brightness, Settings.settings.scene.star.glowFactor, size.floatValue(), GaiaSky.instance.cameraManager.getFovFactor(), Settings.settings.program.modeCubemap.active));
                        lightglow.setSpiralScale(this.getGlowSpiralScale(Settings.settings.scene.star.brightness, size.floatValue(), GaiaSky.instance.cameraManager.getFovFactor()));
                    }
                });
                break;
            }
            case LIGHT_POS_2D_UPDATE: {
                Integer nLights = (Integer)data[0];
                float[] lightPos = (float[])data[1];
                float[] angles = (float[])data[2];
                float[] colors = (float[])data[3];
                float[] alphas = new float[nLights.intValue()];
                Texture occlusionTexture = (Texture)data[4];
                Settings.PostprocessSettings.LensFlareSettings lensFlareSettings = Settings.settings.postprocess.lensFlare;
                int nLightsFlare = 0;
                int i = 0;
                for (int k = 0; k < nLights; ++k) {
                    float angle = angles[k];
                    float lensFlareAngle0 = 1.0E-6f;
                    float lensFlareAngle1 = 5.0E-8f;
                    if (angle > 5.0E-8f) {
                        ++nLightsFlare;
                        alphas[i] = 1.0f;
                        if (angle < 1.0E-6f) {
                            alphas[i] = MathUtilsDouble.lint(angle, 5.0E-8f, 1.0E-6f, 0.0f, 1.0f);
                        }
                    }
                    ++i;
                }
                for (i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    LensFlare lensFlare;
                    if (this.pps[i] == null) continue;
                    IPostProcessor.PostProcessBean ppb = this.pps[i];
                    LightGlow lightGlow = (LightGlow)ppb.get(LightGlow.class);
                    if (lightGlow != null && lightGlow.isEnabled()) {
                        lightGlow.setLightPositions(nLights, lightPos);
                        lightGlow.setLightSolidAngles(angles);
                        lightGlow.setLightColors(colors);
                        if (occlusionTexture != null) {
                            lightGlow.setOcclusionTexture(occlusionTexture);
                        }
                    }
                    if (lensFlareSettings.type.isPseudoLensFlare() || (lensFlare = (LensFlare)ppb.get(LensFlare.class)) == null || !lensFlare.isEnabled()) continue;
                    lensFlare.setLightPositions(nLightsFlare, lightPos, alphas);
                    if (nLights <= 0) {
                        lensFlare.setIntensity(0.0f);
                        continue;
                    }
                    lensFlare.setIntensity(lensFlareSettings.strength);
                }
                break;
            }
            case LIGHT_GLOW_CMD: {
                Boolean lightGlowActive = (Boolean)data[0];
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    IPostProcessor.PostProcessBean ppb;
                    LightGlow lightGlow;
                    if (this.pps[i] == null || (lightGlow = (LightGlow)(ppb = this.pps[i]).get(LightGlow.class)) == null) continue;
                    lightGlow.setEnabled(lightGlowActive);
                }
                break;
            }
            case FOV_CHANGED_CMD: {
                Float newFov = (Float)data[0];
                GaiaSky.postRunnable(() -> {
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        ChromaticAberration aberration;
                        Reprojection reprojection;
                        if (this.pps[i] == null) continue;
                        IPostProcessor.PostProcessBean ppb = this.pps[i];
                        LightGlow lightGlow = (LightGlow)ppb.get(LightGlow.class);
                        if (lightGlow != null) {
                            lightGlow.setTextureScale(this.getGlowTextureScale(Settings.settings.scene.star.brightness, Settings.settings.scene.star.glowFactor, Settings.settings.scene.star.pointSize, GaiaSky.instance.cameraManager.getFovFactor(), Settings.settings.program.modeCubemap.active));
                            lightGlow.setSpiralScale(this.getGlowSpiralScale(Settings.settings.scene.star.brightness, Settings.settings.scene.star.pointSize, GaiaSky.instance.cameraManager.getFovFactor()));
                        }
                        if ((reprojection = (Reprojection)ppb.get(Reprojection.class)) != null) {
                            reprojection.setFov(newFov.floatValue());
                        }
                        if ((aberration = (ChromaticAberration)ppb.get(ChromaticAberration.class)) == null || !(aberration.getAberrationAmount() > 0.0f)) continue;
                        float amount = Settings.settings.postprocess.chromaticAberration.amount * (newFov.floatValue() / 40.0f);
                        aberration.setAberrationAmount(amount);
                        aberration.setEnabled(amount > 0.0f);
                    }
                });
                break;
            }
            case SCREENSHOT_SIZE_UPDATE: {
                if (this.pps == null || !Settings.settings.screenshot.isAdvancedMode()) break;
                Integer newWidth = (Integer)data[0];
                Integer newHeight = (Integer)data[1];
                if (this.pps[IPostProcessor.RenderType.screenshot.index] != null) {
                    if (!this.changed(this.pps[IPostProcessor.RenderType.screenshot.index].pp, newWidth, newHeight)) break;
                    GaiaSky.postRunnable(() -> this.replace(IPostProcessor.RenderType.screenshot, newWidth.intValue(), newHeight.intValue(), newWidth.intValue(), newHeight.intValue()));
                    break;
                }
                this.pps[IPostProcessor.RenderType.screenshot.index] = this.newPostProcessor(IPostProcessor.RenderType.screenshot, newWidth.intValue(), newHeight.intValue(), newWidth.intValue(), newHeight.intValue(), this.manager);
                break;
            }
            case FRAME_SIZE_UPDATE: {
                if (this.pps == null || !Settings.settings.frame.isAdvancedMode()) break;
                Integer newWidth = (Integer)data[0];
                Integer newHeight = (Integer)data[1];
                if (this.pps[IPostProcessor.RenderType.frame.index] != null) {
                    if (!this.changed(this.pps[IPostProcessor.RenderType.frame.index].pp, newWidth, newHeight)) break;
                    GaiaSky.postRunnable(() -> this.replace(IPostProcessor.RenderType.frame, newWidth.intValue(), newHeight.intValue(), newWidth.intValue(), newHeight.intValue()));
                    break;
                }
                GaiaSky.postRunnable(() -> this.replace(IPostProcessor.RenderType.frame, newWidth.intValue(), newHeight.intValue(), newWidth.intValue(), newHeight.intValue()));
                break;
            }
            case BLOOM_CMD: {
                GaiaSky.postRunnable(() -> {
                    float intensity = ((Float)data[0]).floatValue();
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        if (this.pps[i] == null) continue;
                        IPostProcessor.PostProcessBean ppb = this.pps[i];
                        Bloom bloom = (Bloom)ppb.get(Bloom.class);
                        bloom.setBloomIntesnity(intensity);
                        bloom.setEnabled(intensity > 0.0f);
                    }
                });
                break;
            }
            case UNSHARP_MASK_CMD: {
                GaiaSky.postRunnable(() -> {
                    float sharpenFactor = ((Float)data[0]).floatValue();
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        if (this.pps[i] == null) continue;
                        IPostProcessor.PostProcessBean ppb = this.pps[i];
                        UnsharpMask unsharp = (UnsharpMask)ppb.get(UnsharpMask.class);
                        unsharp.setSharpenFactor(sharpenFactor);
                        unsharp.setEnabled(sharpenFactor > 0.0f);
                    }
                });
                break;
            }
            case CHROMATIC_ABERRATION_CMD: {
                GaiaSky.postRunnable(() -> {
                    float amount = ((Float)data[0]).floatValue() * GaiaSky.instance.getCameraManager().getFovFactor();
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        if (this.pps[i] == null) continue;
                        IPostProcessor.PostProcessBean ppb = this.pps[i];
                        ChromaticAberration aberration = (ChromaticAberration)ppb.get(ChromaticAberration.class);
                        aberration.setAberrationAmount(amount);
                        aberration.setEnabled(amount > 0.0f);
                    }
                });
                break;
            }
            case FILM_GRAIN_CMD: {
                GaiaSky.postRunnable(() -> {
                    float intensity = ((Float)data[0]).floatValue();
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        if (this.pps[i] == null) continue;
                        IPostProcessor.PostProcessBean ppb = this.pps[i];
                        FilmGrain grain = (FilmGrain)ppb.get(FilmGrain.class);
                        grain.setIntensity(intensity);
                        grain.setEnabled(intensity != 0.0f);
                    }
                });
                break;
            }
            case LENS_FLARE_CMD: {
                Float strength = (Float)data[0];
                boolean enabled = strength.floatValue() > 0.0f;
                Settings.PostprocessSettings.LensFlareSettings lensFlareSettings = Settings.settings.postprocess.lensFlare;
                if (lensFlareSettings.type.isPseudoLensFlare()) {
                    float intensity = enabled ? strength.floatValue() * 0.15f : 0.0f;
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        if (this.pps[i] == null) continue;
                        IPostProcessor.PostProcessBean ppb = this.pps[i];
                        PseudoLensFlare lensFlare = (PseudoLensFlare)ppb.get(PseudoLensFlare.class);
                        lensFlare.setEnabled(enabled);
                        lensFlare.setFlareIntensity(intensity);
                    }
                } else {
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        IPostProcessor.PostProcessBean ppb = this.pps[i];
                        LensFlare lensFlare = (LensFlare)ppb.get(LensFlare.class);
                        lensFlare.setEnabled(enabled);
                        lensFlare.setIntensity(strength.floatValue());
                    }
                }
                break;
            }
            case RAYMARCHING_CMD: {
                String name = (String)data[0];
                Boolean status = (Boolean)data[1];
                Entity entity = (Entity)data[2];
                if (data.length > 3) {
                    Object[] l;
                    String shader = (String)data[3];
                    if (data.length > 4) {
                        float[] additional;
                        float[] fArray = additional = data[4] != null ? (float[])data[4] : null;
                        if (data.length > 5) {
                            Texture rmTexture = (Texture)data[5];
                            l = new Object[]{shader, false, entity, additional, rmTexture};
                        } else {
                            l = new Object[]{shader, false, entity, additional};
                        }
                    } else {
                        l = new Object[]{shader, false, entity};
                    }
                    this.addRayMarchingDef(name, l);
                    logger.debug("Ray marching effect definition added: [" + name + " | " + shader + " | " + String.valueOf(entity) + "]");
                    break;
                }
                float rmTime = this.getRaymarchingTime();
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    IPostProcessor.PostProcessBean ppb;
                    Map<String, PostProcessorEffect> rms;
                    if (this.pps[i] == null || (rms = (ppb = this.pps[i]).getAll(RaymarchObject.class)) == null) continue;
                    rms.forEach((key, rmEffect) -> {
                        RaymarchObject raymarchObject = (RaymarchObject)rmEffect;
                        raymarchObject.setEnabled(status);
                        Entity rmEntity = (Entity)this.rayMarchingDefinitions.get(key)[2];
                        this.focusView.setScene(this.scene);
                        this.focusView.setEntity(rmEntity);
                        this.focusView.getPredictedPosition(this.v3b2, GaiaSky.instance.time, GaiaSky.instance.getICamera(), true);
                        Vector3 camPos = this.v3b1.set(GaiaSky.instance.getCameraManager().getPos()).sub(this.v3b2).put(this.v3f1);
                        raymarchObject.setTime(rmTime);
                        raymarchObject.setPos(camPos);
                    });
                }
                break;
            }
            case RAYMARCHING_ADDITIONAL_CMD: {
                String name = (String)data[0];
                float[] additional = (float[])data[1];
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    PostProcessorEffect ppe;
                    IPostProcessor.PostProcessBean ppb;
                    Map<String, PostProcessorEffect> rms;
                    if (this.pps[i] == null || (rms = (ppb = this.pps[i]).getAll(RaymarchObject.class)) == null || (ppe = rms.get(name)) == null) continue;
                    ((RaymarchObject)ppe).setAdditional(additional);
                }
                break;
            }
            case CAMERA_MOTION_UPDATE: {
                PerspectiveCamera camera = (PerspectiveCamera)data[3];
                Vector3Q campos = (Vector3Q)data[0];
                float rmTime = this.getRaymarchingTime();
                float cameraOffset = camera.direction.x + camera.direction.y + camera.direction.z;
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    Map<String, PostProcessorEffect> rms;
                    LightGlow glow;
                    if (this.pps[i] == null) continue;
                    IPostProcessor.PostProcessBean ppb = this.pps[i];
                    PseudoLensFlare flare = (PseudoLensFlare)ppb.get(PseudoLensFlare.class);
                    if (flare != null) {
                        flare.setStarburstOffset(cameraOffset);
                    }
                    if ((glow = (LightGlow)ppb.get(LightGlow.class)) != null) {
                        glow.setOrientation(cameraOffset * 50.0f);
                    }
                    if ((rms = ppb.getAll(RaymarchObject.class)) == null) continue;
                    rms.forEach((key, rmEffect) -> {
                        if (rmEffect.isEnabled()) {
                            Entity rmEntity = (Entity)this.rayMarchingDefinitions.get(key)[2];
                            this.focusView.setScene(this.scene);
                            this.focusView.setEntity(rmEntity);
                            this.focusView.getPredictedPosition(this.v3b2, GaiaSky.instance.time, GaiaSky.instance.getICamera(), true);
                            Vector3 camPos = this.v3b1.set(campos).sub(this.v3b2).put(this.v3f1);
                            RaymarchObject raymarchObject = (RaymarchObject)rmEffect;
                            raymarchObject.setTime(rmTime);
                            raymarchObject.setPos(camPos);
                        }
                    });
                }
                this.prevViewProj.set(camera.combined);
                break;
            }
            case CAMERA_ORIENTATION_UPDATE: {
                PerspectiveCamera camera = (PerspectiveCamera)data[0];
                Integer w = (Integer)data[1];
                Integer h = (Integer)data[2];
                CameraManager.getFrustumCornersEye(camera, this.frustumCorners);
                this.view.set(camera.view);
                this.projection.set(camera.projection);
                this.combined.set(camera.combined);
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    Map<String, PostProcessorEffect> ssrs;
                    if (this.pps[i] == null) continue;
                    IPostProcessor.PostProcessBean ppb = this.pps[i];
                    Map<String, PostProcessorEffect> rms = ppb.getAll(RaymarchObject.class);
                    if (rms != null) {
                        rms.forEach((key, rmEffect) -> {
                            if (rmEffect.isEnabled()) {
                                RaymarchObject raymarchObject = (RaymarchObject)rmEffect;
                                raymarchObject.setFrustumCorners(this.frustumCorners);
                                raymarchObject.setView(this.view);
                                raymarchObject.setCombined(this.combined);
                                raymarchObject.setViewportSize(w, h);
                            }
                        });
                    }
                    if ((ssrs = ppb.getAll(SSR.class)) == null) continue;
                    ssrs.forEach((key, ssrEffect) -> {
                        if (ssrEffect.isEnabled()) {
                            SSR ssr = (SSR)ssrEffect;
                            ssr.setFrustumCorners(this.frustumCorners);
                            ssr.setView(this.view);
                            ssr.setProjection(this.projection);
                            ssr.setCombined(this.combined);
                        }
                    });
                }
                break;
            }
            case REPROJECTION_CMD: {
                Boolean active = (Boolean)data[0];
                Settings.ReprojectionMode mode = (Settings.ReprojectionMode)((Object)data[1]);
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    LightGlow glow;
                    if (this.pps[i] == null) continue;
                    IPostProcessor.PostProcessBean ppb = this.pps[i];
                    Reprojection reprojection = (Reprojection)ppb.get(Reprojection.class);
                    if (reprojection != null) {
                        reprojection.setEnabled(active);
                        reprojection.setMode(mode.mode);
                    }
                    if ((glow = (LightGlow)ppb.get(LightGlow.class)) == null) continue;
                    glow.setNSamples(active != false ? 1 : Settings.settings.postprocess.lightGlow.samples);
                }
                break;
            }
            case SSR_CMD: {
                boolean enabled = (Boolean)data[0] != false && !Settings.settings.program.safeMode && !Settings.settings.runtime.openXr;
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    IPostProcessor.PostProcessBean ppb;
                    SSR ssr;
                    if (this.pps[i] == null || (ssr = (SSR)(ppb = this.pps[i]).get(SSR.class)) == null) continue;
                    ssr.setEnabled(enabled);
                }
                break;
            }
            case MOTION_BLUR_CMD: {
                Float strength = (Float)data[0];
                boolean enabled = strength.floatValue() > 0.0f && !Settings.settings.program.safeMode && !Settings.settings.runtime.openXr;
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    IPostProcessor.PostProcessBean ppb;
                    CameraMotionBlur cameraMotion;
                    if (this.pps[i] == null || (cameraMotion = (CameraMotionBlur)(ppb = this.pps[i]).get(CameraMotionBlur.class)) == null) continue;
                    cameraMotion.setEnabled(enabled);
                    cameraMotion.setBlurScale(strength.floatValue());
                }
                break;
            }
            case CUBEMAP_CMD: {
                Boolean cubemap = (Boolean)data[0];
                boolean enabled = cubemap != false && !Settings.settings.runtime.openXr;
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    LightGlow lightglow;
                    if (this.pps[i] == null) continue;
                    IPostProcessor.PostProcessBean ppb = this.pps[i];
                    CameraMotionBlur cameraMotion = (CameraMotionBlur)ppb.get(CameraMotionBlur.class);
                    if (cameraMotion != null) {
                        cameraMotion.setEnabled(enabled);
                    }
                    if ((lightglow = (LightGlow)ppb.get(LightGlow.class)) == null) continue;
                    lightglow.setNSamples(enabled ? 1 : Settings.settings.postprocess.lightGlow.samples);
                    lightglow.setTextureScale(this.getGlowTextureScale(Settings.settings.scene.star.brightness, Settings.settings.scene.star.glowFactor, Settings.settings.scene.star.pointSize, GaiaSky.instance.cameraManager.getFovFactor(), Settings.settings.program.modeCubemap.active));
                }
                break;
            }
            case STEREOSCOPIC_CMD: {
                if (Settings.settings.runtime.openXr) break;
                this.updateStereo((Boolean)data[0], Settings.settings.program.modeStereo.profile);
                break;
            }
            case STEREO_PROFILE_CMD: {
                if (Settings.settings.runtime.openXr) break;
                this.updateStereo(Settings.settings.program.modeStereo.active, Settings.StereoProfile.values()[(Integer)data[0]]);
                break;
            }
            case ANTIALIASING_CMD: {
                Settings.PostprocessSettings.AntialiasType antiAliasingValue = (Settings.PostprocessSettings.AntialiasType)((Object)data[0]);
                GaiaSky.postRunnable(() -> {
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        if (this.pps[i] == null) continue;
                        IPostProcessor.PostProcessBean ppb = this.pps[i];
                        Antialiasing antialiasing = this.getAA(ppb);
                        if (antiAliasingValue.isPostProcessAntialias()) {
                            if (antialiasing != null) {
                                ppb.remove(antialiasing.getClass());
                            }
                            this.initAntiAliasing(antiAliasingValue, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), ppb);
                            ppb.remove(Levels.class);
                            this.initLevels(ppb);
                            continue;
                        }
                        if (antialiasing == null) continue;
                        ppb.remove(antialiasing.getClass());
                    }
                });
                break;
            }
            case BRIGHTNESS_CMD: {
                Float br = (Float)data[0];
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    IPostProcessor.PostProcessBean ppb;
                    Levels levels;
                    if (this.pps[i] == null || (levels = (Levels)(ppb = this.pps[i]).get(Levels.class)) == null) continue;
                    levels.setBrightness(br.floatValue());
                }
                break;
            }
            case CONTRAST_CMD: {
                Float cn = (Float)data[0];
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    IPostProcessor.PostProcessBean ppb;
                    Levels levels;
                    if (this.pps[i] == null || (levels = (Levels)(ppb = this.pps[i]).get(Levels.class)) == null) continue;
                    levels.setContrast(cn.floatValue());
                }
                break;
            }
            case HUE_CMD: {
                Float hue = (Float)data[0];
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    IPostProcessor.PostProcessBean ppb;
                    Levels levels;
                    if (this.pps[i] == null || (levels = (Levels)(ppb = this.pps[i]).get(Levels.class)) == null) continue;
                    levels.setHue(hue.floatValue());
                }
                break;
            }
            case SATURATION_CMD: {
                Float sat = (Float)data[0];
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    IPostProcessor.PostProcessBean ppb;
                    Levels levels;
                    if (this.pps[i] == null || (levels = (Levels)(ppb = this.pps[i]).get(Levels.class)) == null) continue;
                    levels.setSaturation(sat.floatValue());
                }
                break;
            }
            case GAMMA_CMD: {
                Float gamma = (Float)data[0];
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    IPostProcessor.PostProcessBean ppb;
                    Levels levels;
                    if (this.pps[i] == null || (levels = (Levels)(ppb = this.pps[i]).get(Levels.class)) == null) continue;
                    levels.setGamma(gamma.floatValue());
                }
                break;
            }
            case TONEMAPPING_TYPE_CMD: {
                Settings.ToneMapping tm = data[0] instanceof String ? Settings.ToneMapping.valueOf((String)data[0]) : (Settings.ToneMapping)((Object)data[0]);
                block64: for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    IPostProcessor.PostProcessBean ppb;
                    Levels levels;
                    if (this.pps[i] == null || (levels = (Levels)(ppb = this.pps[i]).get(Levels.class)) == null) continue;
                    switch (tm) {
                        case AUTO: {
                            levels.enableToneMappingAuto();
                            continue block64;
                        }
                        case EXPOSURE: {
                            levels.enableToneMappingExposure();
                            continue block64;
                        }
                        case ACES: {
                            levels.enableToneMappingACES();
                            continue block64;
                        }
                        case UNCHARTED: {
                            levels.enableToneMappingUncharted();
                            continue block64;
                        }
                        case FILMIC: {
                            levels.enableToneMappingFilmic();
                            continue block64;
                        }
                        case NONE: {
                            levels.disableToneMapping();
                        }
                    }
                }
                break;
            }
            case EXPOSURE_CMD: {
                Float exposure = (Float)data[0];
                for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                    IPostProcessor.PostProcessBean ppb;
                    Levels levels;
                    if (this.pps[i] == null || (levels = (Levels)(ppb = this.pps[i]).get(Levels.class)) == null) continue;
                    levels.setExposure(exposure.floatValue());
                }
                break;
            }
            case BILLBOARD_TEXTURE_IDX_CMD: {
                GaiaSky.postRunnable(() -> {
                    Texture starTex = new Texture(Settings.settings.data.dataFileHandle(Settings.settings.scene.star.getStarTexture()), true);
                    starTex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        if (this.pps[i] == null) continue;
                        IPostProcessor.PostProcessBean ppb = this.pps[i];
                        ((LightGlow)ppb.get(LightGlow.class)).setLightGlowTexture(starTex);
                    }
                });
                break;
            }
            case BACKBUFFER_SCALE_CMD: {
                this.updateUpscaleFilters(Settings.settings.postprocess.upscaleFilter, ((Float)data[0]).floatValue());
                break;
            }
            case UPSCALE_FILTER_CMD: {
                Settings.UpscaleFilter upscaleFilter = (Settings.UpscaleFilter)((Object)data[0]);
                this.updateUpscaleFilters(upscaleFilter, (float)Settings.settings.graphics.backBufferScale);
                break;
            }
            case SHADER_RELOAD_CMD: {
                GaiaSky.postRunnable(() -> {
                    for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
                        if (this.pps[i] == null) continue;
                        Map<Class<? extends PostProcessorEffect>, Map<String, PostProcessorEffect>> effects = this.pps[i].effects;
                        for (Class<? extends PostProcessorEffect> mapsKey : effects.keySet()) {
                            Map<String, PostProcessorEffect> effectsMap = effects.get(mapsKey);
                            for (String key : effectsMap.keySet()) {
                                PostProcessorEffect effect = effectsMap.get(key);
                                effect.updateShaders();
                            }
                        }
                    }
                });
                break;
            }
        }
    }

    private float getRaymarchingTime() {
        ZonedDateTime zdt = GaiaSky.instance.time.getTime().atZone(ZoneId.systemDefault());
        return (float)((double)zdt.getSecond() + (double)zdt.getNano() * 1.0E-9);
    }

    private Antialiasing getAA(IPostProcessor.PostProcessBean ppb) {
        PostProcessorEffect ppe = ppb.get(Fxaa.class);
        if (ppe == null && (ppe = ppb.get(Nfaa.class)) == null) {
            return null;
        }
        return (Antialiasing)ppe;
    }

    private void replace(IPostProcessor.RenderType rt, float width, float height, float targetWidth, float targetHeight) {
        if (this.pps[rt.index] != null) {
            this.pps[rt.index].dispose(false);
        }
        this.pps[rt.index] = this.newPostProcessor(rt, width, height, targetWidth, targetHeight, this.manager);
    }

    private boolean changed(PostProcessor postProcess, int width, int height) {
        return postProcess.getCombinedBuffer().width != width || postProcess.getCombinedBuffer().height != height;
    }

    @Override
    public boolean isEnabled(Class<? extends PostProcessorEffect> clazz) {
        if (this.pps == null || this.pps[IPostProcessor.RenderType.screen.index] == null) {
            return false;
        }
        PostProcessorEffect effect = this.pps[IPostProcessor.RenderType.screen.index].get(clazz);
        return effect != null && effect.isEnabled();
    }

    @Override
    public boolean isLightScatterEnabled() {
        return this.isEnabled(LightGlow.class);
    }

    @Override
    public boolean isLensFlareEnabled() {
        return this.isEnabled(LensFlare.class);
    }

    private void updateStereo(boolean stereo, Settings.StereoProfile profile) {
        boolean curvatureEnabled = stereo && profile == Settings.StereoProfile.VR_HEADSET;
        boolean viewportHalved = stereo && !profile.isAnaglyph() && profile != Settings.StereoProfile.HORIZONTAL_3DTV;
        for (int i = 0; i < IPostProcessor.RenderType.values().length; ++i) {
            if (this.pps[i] == null) continue;
            IPostProcessor.PostProcessBean ppb = this.pps[i];
            ppb.get(Curvature.class).setEnabled(curvatureEnabled);
            IPostProcessor.RenderType currentRenderType = IPostProcessor.RenderType.values()[i];
            int[] size = this.getSize(currentRenderType);
            ((LightGlow)ppb.get(LightGlow.class)).setViewportSize(size[0] / (viewportHalved ? 2 : 1), size[1]);
        }
    }

    private void updateUpscaleFilters(Settings.UpscaleFilter upscaleFilter, double backBufferScale) {
        if (this.pps[IPostProcessor.RenderType.screen.index] != null) {
            IPostProcessor.PostProcessBean ppb = this.pps[IPostProcessor.RenderType.screen.index];
            XBRZ filter = (XBRZ)ppb.get(XBRZ.class);
            this.updateUpscaleFilter(upscaleFilter, backBufferScale, filter, ppb);
        }
    }

    private void updateUpscaleFilter(Settings.UpscaleFilter upscaleFilter, double backBufferScale, XBRZ filter, IPostProcessor.PostProcessBean ppb) {
        boolean enabled = backBufferScale < 1.0 && upscaleFilter.equals((Object)Settings.UpscaleFilter.XBRZ);
        filter.setEnabled(enabled);
        if (enabled) {
            int w = ppb.pp.getCombinedBuffer().width;
            int h = ppb.pp.getCombinedBuffer().height;
            filter.setInputSize(w, h);
            filter.setOutputSize((int)((double)w / backBufferScale), (int)((double)h / backBufferScale));
        }
        ppb.pp.setBufferTextureFilter(upscaleFilter.minification, upscaleFilter.magnification);
    }
}

