/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import gaiasky.render.util.ShaderLoader;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.gdx.IntModelBatch;
import gaiasky.util.gdx.g2d.BitmapFont;
import gaiasky.util.gdx.g2d.ExtSpriteBatch;
import gaiasky.util.gdx.loader.BitmapFontLoader;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.loader.AtmosphereShaderProviderLoader;
import gaiasky.util.gdx.shader.loader.GroundShaderProviderLoader;
import gaiasky.util.gdx.shader.loader.RelativisticShaderProviderLoader;
import gaiasky.util.gdx.shader.loader.TessellationShaderProviderLoader;
import gaiasky.util.gdx.shader.provider.AtmosphereShaderProvider;
import gaiasky.util.gdx.shader.provider.GroundShaderProvider;
import gaiasky.util.gdx.shader.provider.IntShaderProvider;
import gaiasky.util.gdx.shader.provider.RelativisticShaderProvider;
import gaiasky.util.gdx.shader.provider.ShaderProgramProvider;
import gaiasky.util.gdx.shader.provider.TessellationShaderProvider;
import gaiasky.util.i18n.I18n;

public class RenderAssets {
    public static final String SUFFIX_SSR = "SSR";
    public static final String SUFFIX_REL = "Rel";
    public static final String SUFFIX_GRAV = "Grav";
    public static final String SUFFIX_COLMAP = "Colmap";
    private static final Logger.Log logger = Logger.getLogger(RenderAssets.class);
    private final GlobalResources globalResources;
    public ExtShaderProgram distanceFieldFontShader;
    public ExtShaderProgram[] billboardShaders;
    public ExtShaderProgram[] galShaders;
    public ExtShaderProgram[] spriteShaders;
    public ExtShaderProgram[] pointShaders;
    public ExtShaderProgram[] lineCpuShaders;
    public ExtShaderProgram[] lineQuadCpuShaders;
    public ExtShaderProgram[] lineQuadGpuShaders;
    public ExtShaderProgram[] primitiveGpuShaders;
    public ExtShaderProgram[] billboardGroupShaders;
    public ExtShaderProgram[] particleEffectShaders;
    public ExtShaderProgram[] particleGroupShaders;
    public ExtShaderProgram[] particleGroupExtBillboardShaders;
    public ExtShaderProgram[] particleGroupExtModelShaders;
    public ExtShaderProgram[] starGroupShaders;
    public ExtShaderProgram[] variableGroupShaders;
    public ExtShaderProgram[] starPointShaders;
    public ExtShaderProgram[] orbitElemShaders;
    public IntModelBatch mbVertexLighting;
    public IntModelBatch mbVertexLightingAdditive;
    public IntModelBatch mbVertexDiffuse;
    public IntModelBatch mbVertexLightingStarSurface;
    public IntModelBatch mbVertexLightingThruster;
    public IntModelBatch mbVertexLightingGrid;
    public IntModelBatch mbVertexLightingRecGrid;
    public IntModelBatch mbPixelLighting;
    public IntModelBatch mbPixelLightingDust;
    public IntModelBatch mbPixelLightingDepth;
    public IntModelBatch mbPixelLightingOpaque;
    public IntModelBatch mbPixelLightingSvtDetection;
    public IntModelBatch mbPixelLightingTessellation;
    public IntModelBatch mbPixelLightingOpaqueTessellation;
    public IntModelBatch mbPixelLightingSvtDetectionTessellation;
    public IntModelBatch mbPixelLightingDepthTessellation;
    public IntModelBatch mbSkybox;
    public IntModelBatch mbAtmosphere;
    public IntModelBatch mbCloud;
    public BitmapFont fontDistanceFiled;
    public ExtSpriteBatch spriteBatch;
    public ExtSpriteBatch fontBatch;
    private AssetDescriptor<ExtShaderProgram>[] starGroupDesc;
    private AssetDescriptor<ExtShaderProgram>[] particleGroupDesc;
    private AssetDescriptor<ExtShaderProgram>[] particleGroupExtBillboardDesc;
    private AssetDescriptor<ExtShaderProgram>[] particleGroupExtModelDesc;
    private AssetDescriptor<ExtShaderProgram>[] variableGroupDesc;
    private AssetDescriptor<ExtShaderProgram>[] particleEffectDesc;
    private AssetDescriptor<ExtShaderProgram>[] orbitElemDesc;
    private AssetDescriptor<ExtShaderProgram>[] pointDesc;
    private AssetDescriptor<ExtShaderProgram>[] lineCpuDesc;
    private AssetDescriptor<ExtShaderProgram>[] lineQuadCpuDesc;
    private AssetDescriptor<ExtShaderProgram>[] lineQuadGpuDesc;
    private AssetDescriptor<ExtShaderProgram>[] primitiveGpuDesc;
    private AssetDescriptor<ExtShaderProgram>[] billboardGroupDesc;
    private AssetDescriptor<ExtShaderProgram>[] starPointDesc;
    private AssetDescriptor<ExtShaderProgram>[] galDesc;
    private AssetDescriptor<ExtShaderProgram>[] spriteDesc;
    private AssetDescriptor<ExtShaderProgram>[] billboardDesc;

    public RenderAssets(GlobalResources globalResources) {
        this.globalResources = globalResources;
    }

    public void initialize(AssetManager manager) {
        boolean safeMode = Settings.settings.program.safeMode;
        ShaderLoader.Pedantic = false;
        ExtShaderProgram.pedantic = false;
        Array namesSource = new Array(String.class);
        Array definesSource = new Array(String.class);
        namesSource.add((Object)SUFFIX_SSR);
        definesSource.add((Object)"#define ssrFlag\n");
        if (Settings.settings.runtime.relativisticAberration && Settings.settings.runtime.gravitationalWaves) {
            namesSource.add((Object)SUFFIX_REL, (Object)SUFFIX_GRAV);
            definesSource.add((Object)"#define relativisticEffects\n", (Object)"#define gravitationalWaves\n");
        }
        String[] defines = GlobalResources.combinations((String[])definesSource.toArray());
        String[] names = GlobalResources.combinations((String[])namesSource.toArray());
        Array namesSourceColMap = new Array(namesSource);
        Array definesSourceColMap = new Array(definesSource);
        namesSourceColMap.add((Object)SUFFIX_COLMAP);
        definesSourceColMap.add((Object)"#define colorMap\n");
        String[] definesColMap = GlobalResources.combinations((String[])definesSourceColMap.toArray());
        String[] namesColMap = GlobalResources.combinations((String[])namesSourceColMap.toArray());
        this.billboardDesc = this.loadShader(manager, "shader/billboard.vertex.glsl", "shader/billboard.fragment.glsl", TextUtils.concatAll("regular.billboard", names), defines);
        this.spriteDesc = this.loadShader(manager, "shader/sprite.vertex.glsl", "shader/sprite.fragment.glsl", TextUtils.concatAll("sprite", names), defines);
        this.billboardGroupDesc = this.loadShader(manager, "shader/billboard.group.vertex.glsl", "shader/billboard.group.fragment.glsl", TextUtils.concatAll("billboard.group", names), defines);
        this.pointDesc = this.loadShader(manager, "shader/point.cpu.vertex.glsl", "shader/point.cpu.fragment.glsl", TextUtils.concatAll("point.cpu", names), defines);
        this.lineCpuDesc = this.loadShader(manager, "shader/line.cpu.vertex.glsl", "shader/line.cpu.fragment.glsl", TextUtils.concatAll("line.cpu", names), defines);
        if (!safeMode) {
            this.lineQuadCpuDesc = this.loadShader(manager, "shader/line.quad.cpu.vertex.glsl", "shader/line.quad.cpu.geometry.glsl", "shader/line.quad.cpu.fragment.glsl", TextUtils.concatAll("line.quad.cpu", names), defines);
            this.lineQuadGpuDesc = this.loadShader(manager, "shader/line.quad.gpu.vertex.glsl", "shader/line.quad.gpu.geometry.glsl", "shader/line.quad.gpu.fragment.glsl", TextUtils.concatAll("line.quad.gpu", names), defines);
        }
        this.primitiveGpuDesc = this.loadShader(manager, "shader/line.gpu.vertex.glsl", "shader/line.gpu.fragment.glsl", TextUtils.concatAll("primitive.gpu", names), defines);
        this.galDesc = this.loadShader(manager, "shader/gal.vertex.glsl", "shader/gal.fragment.glsl", TextUtils.concatAll("gal", names), defines);
        this.particleEffectDesc = this.loadShader(manager, "shader/particle.effect.vertex.glsl", "shader/particle.effect.fragment.glsl", TextUtils.concatAll("particle.effect", names), defines);
        this.orbitElemDesc = this.loadShader(manager, "shader/orbitelem.vertex.glsl", "shader/particle.group.quad.fragment.glsl", TextUtils.concatAll("orbitelem", names), defines);
        String pointTriSuffix = Settings.settings.scene.renderer.pointCloud.isTriangles() ? ".quad" : ".point";
        String pointTriSuffixParticles = Settings.settings.scene.renderer.pointCloud.isTriangles() ? ".quad" : ".point";
        this.particleGroupDesc = this.loadShader(manager, "shader/particle.group" + pointTriSuffixParticles + ".vertex.glsl", "shader/particle.group" + pointTriSuffixParticles + ".fragment.glsl", TextUtils.concatAll("particle.group", namesColMap), definesColMap);
        this.particleGroupExtBillboardDesc = this.loadShader(manager, "shader/particle.group.quad.vertex.glsl", "shader/particle.group.quad.fragment.glsl", TextUtils.concatAll("particle.group.ext", namesColMap), definesColMap, "#define extendedParticlesFlag");
        this.particleGroupExtModelDesc = this.loadShader(manager, "shader/particle.group.model.vertex.glsl", "shader/particle.group.model.fragment.glsl", TextUtils.concatAll("particle.group.ext.model", namesColMap), definesColMap, "#define extendedParticlesFlag");
        this.starGroupDesc = this.loadShader(manager, "shader/star.group" + pointTriSuffix + ".vertex.glsl", "shader/star.group" + pointTriSuffix + ".fragment.glsl", TextUtils.concatAll("star.group", namesColMap), definesColMap);
        this.variableGroupDesc = this.loadShader(manager, "shader/variable.group" + pointTriSuffix + ".vertex.glsl", "shader/star.group" + pointTriSuffix + ".fragment.glsl", TextUtils.concatAll("variable.group", namesColMap), definesColMap);
        this.starPointDesc = this.loadShader(manager, "shader/star.group.point.vertex.glsl", "shader/star.group.point.fragment.glsl", TextUtils.concatAll("star.point", names), defines);
        manager.load("per-vertex-lighting", GroundShaderProvider.class, (AssetLoaderParameters)new GroundShaderProviderLoader.GroundShaderProviderParameter("shader/default.vertex.glsl", "shader/default.fragment.glsl"));
        manager.load("per-vertex-lighting-additive", RelativisticShaderProvider.class, (AssetLoaderParameters)new RelativisticShaderProviderLoader.RelativisticShaderProviderParameter("shader/default.vertex.glsl", "shader/default.additive.fragment.glsl"));
        manager.load("per-vertex-diffuse", RelativisticShaderProvider.class, (AssetLoaderParameters)new RelativisticShaderProviderLoader.RelativisticShaderProviderParameter("shader/default.vertex.glsl", "shader/default.diffuse.fragment.glsl"));
        manager.load("per-vertex-lighting-grid", RelativisticShaderProvider.class, (AssetLoaderParameters)new RelativisticShaderProviderLoader.RelativisticShaderProviderParameter("shader/default.vertex.glsl", "shader/grid.fragment.glsl"));
        manager.load("per-vertex-lighting-recgrid", RelativisticShaderProvider.class, (AssetLoaderParameters)new RelativisticShaderProviderLoader.RelativisticShaderProviderParameter("shader/default.vertex.glsl", "shader/gridrec.fragment.glsl"));
        manager.load("per-vertex-lighting-starsurface", RelativisticShaderProvider.class, (AssetLoaderParameters)new RelativisticShaderProviderLoader.RelativisticShaderProviderParameter("shader/starsurface.vertex.glsl", "shader/starsurface.fragment.glsl"));
        manager.load("per-vertex-lighting-thruster", GroundShaderProvider.class, (AssetLoaderParameters)new GroundShaderProviderLoader.GroundShaderProviderParameter("shader/default.vertex.glsl", "shader/thruster.fragment.glsl"));
        manager.load("per-pixel-lighting", GroundShaderProvider.class, (AssetLoaderParameters)new GroundShaderProviderLoader.GroundShaderProviderParameter("shader/pbr.vertex.glsl", "shader/pbr.fragment.glsl"));
        manager.load("per-pixel-lighting-tessellation", TessellationShaderProvider.class, (AssetLoaderParameters)new TessellationShaderProviderLoader.TessellationShaderProviderParameter("shader/tessellation/tess.pbr.vertex.glsl", "shader/tessellation/tess.pbr.control.glsl", "shader/tessellation/tess.pbr.eval.glsl", "shader/tessellation/tess.pbr.fragment.glsl"));
        manager.load("per-pixel-lighting-dust", GroundShaderProvider.class, (AssetLoaderParameters)new GroundShaderProviderLoader.GroundShaderProviderParameter("shader/pbr.vertex.glsl", "shader/dust.fragment.glsl"));
        manager.load("per-pixel-lighting-depth", RelativisticShaderProvider.class, (AssetLoaderParameters)new RelativisticShaderProviderLoader.RelativisticShaderProviderParameter("shader/pbr.vertex.glsl", "shader/depth.fragment.glsl"));
        manager.load("per-pixel-lighting-depth-tessellation", TessellationShaderProvider.class, (AssetLoaderParameters)new TessellationShaderProviderLoader.TessellationShaderProviderParameter("shader/tessellation/tess.simple.vertex.glsl", "shader/tessellation/tess.depth.control.glsl", "shader/tessellation/tess.simple.eval.glsl", "shader/tessellation/tess.depth.fragment.glsl"));
        manager.load("per-pixel-lighting-opaque", RelativisticShaderProvider.class, (AssetLoaderParameters)new RelativisticShaderProviderLoader.RelativisticShaderProviderParameter("shader/pbr.vertex.glsl", "shader/opaque.fragment.glsl"));
        manager.load("per-pixel-lighting-opaque-tessellation", TessellationShaderProvider.class, (AssetLoaderParameters)new TessellationShaderProviderLoader.TessellationShaderProviderParameter("shader/tessellation/tess.simple.vertex.glsl", "shader/tessellation/tess.simple.control.glsl", "shader/tessellation/tess.simple.eval.glsl", "shader/tessellation/tess.opaque.fragment.glsl"));
        manager.load("per-pixel-lighting-svtdetection", RelativisticShaderProvider.class, (AssetLoaderParameters)new RelativisticShaderProviderLoader.RelativisticShaderProviderParameter("shader/pbr.vertex.glsl", "shader/svt.detection.fragment.glsl"));
        manager.load("per-pixel-lighting-svtdetection-tessellation", TessellationShaderProvider.class, (AssetLoaderParameters)new TessellationShaderProviderLoader.TessellationShaderProviderParameter("shader/tessellation/tess.simple.vertex.glsl", "shader/tessellation/tess.simple.control.glsl", "shader/tessellation/tess.simple.eval.glsl", "shader/tessellation/tess.svt.detection.fragment.glsl"));
        manager.load("skybox", RelativisticShaderProvider.class, (AssetLoaderParameters)new RelativisticShaderProviderLoader.RelativisticShaderProviderParameter("shader/skybox.vertex.glsl", "shader/skybox.fragment.glsl"));
        manager.load("atmosphere", AtmosphereShaderProvider.class, (AssetLoaderParameters)new AtmosphereShaderProviderLoader.AtmosphereShaderProviderParameter("shader/atm.vertex.glsl", "shader/atm.fragment.glsl"));
        manager.load("cloud", GroundShaderProvider.class, (AssetLoaderParameters)new GroundShaderProviderLoader.GroundShaderProviderParameter("shader/cloud.vertex.glsl", "shader/cloud.fragment.glsl"));
        manager.load("shader/font.vertex.glsl", ExtShaderProgram.class);
        BitmapFontLoader.BitmapFontParameter bfp = new BitmapFontLoader.BitmapFontParameter();
        bfp.magFilter = Texture.TextureFilter.Linear;
        bfp.minFilter = Texture.TextureFilter.Linear;
        manager.load("skins/fonts/font-distance-field.fnt", BitmapFont.class, (AssetLoaderParameters)bfp);
    }

    public void doneLoading(AssetManager manager) {
        String[] names = GlobalResources.combinations(new String[]{" (ssr)", " (vel)", " (rel)", " (grav)"});
        this.billboardShaders = this.fetchShaderProgram(manager, this.billboardDesc, TextUtils.concatAll("regular.billboard", names));
        this.galShaders = this.fetchShaderProgram(manager, this.galDesc, TextUtils.concatAll("gal", names));
        this.distanceFieldFontShader = this.fetchShaderProgram(manager, "shader/font.vertex.glsl", "distance.field.font");
        this.spriteShaders = this.fetchShaderProgram(manager, this.spriteDesc, TextUtils.concatAll("sprite", names));
        this.pointShaders = this.fetchShaderProgram(manager, this.pointDesc, TextUtils.concatAll("point.cpu", names));
        this.lineCpuShaders = this.fetchShaderProgram(manager, this.lineCpuDesc, TextUtils.concatAll("line.cpu", names));
        if (!Settings.settings.program.safeMode) {
            this.lineQuadCpuShaders = this.fetchShaderProgram(manager, this.lineQuadCpuDesc, TextUtils.concatAll("line.quad.cpu", names));
            this.lineQuadGpuShaders = this.fetchShaderProgram(manager, this.lineQuadGpuDesc, TextUtils.concatAll("line.quad.gpu", names));
        }
        this.primitiveGpuShaders = this.fetchShaderProgram(manager, this.primitiveGpuDesc, TextUtils.concatAll("primitive.gpu", names));
        this.billboardGroupShaders = this.fetchShaderProgram(manager, this.billboardGroupDesc, TextUtils.concatAll("billboard.group", names));
        this.particleEffectShaders = this.fetchShaderProgram(manager, this.particleEffectDesc, TextUtils.concatAll("particle.effect", names));
        this.particleGroupShaders = this.fetchShaderProgram(manager, this.particleGroupDesc, TextUtils.concatAll("particle.group", names));
        this.particleGroupExtBillboardShaders = this.fetchShaderProgram(manager, this.particleGroupExtBillboardDesc, TextUtils.concatAll("particle.group.ext", names));
        this.particleGroupExtModelShaders = this.fetchShaderProgram(manager, this.particleGroupExtModelDesc, TextUtils.concatAll("particle.group.ext.model", names));
        this.starGroupShaders = this.fetchShaderProgram(manager, this.starGroupDesc, TextUtils.concatAll("star.group", names));
        this.variableGroupShaders = this.fetchShaderProgram(manager, this.variableGroupDesc, TextUtils.concatAll("variable.group", names));
        this.starPointShaders = this.fetchShaderProgram(manager, this.starPointDesc, TextUtils.concatAll("star.point", names));
        this.orbitElemShaders = this.fetchShaderProgram(manager, this.orbitElemDesc, TextUtils.concatAll("orbitelem", names));
        IntShaderProvider perVertexLighting = (IntShaderProvider)manager.get("per-vertex-lighting");
        IntShaderProvider perVertexLightingAdditive = (IntShaderProvider)manager.get("per-vertex-lighting-additive");
        IntShaderProvider perVertexDiffuse = (IntShaderProvider)manager.get("per-vertex-diffuse");
        IntShaderProvider perVertexLightingGrid = (IntShaderProvider)manager.get("per-vertex-lighting-grid");
        IntShaderProvider perVertexLightingRecGrid = (IntShaderProvider)manager.get("per-vertex-lighting-recgrid");
        IntShaderProvider perVertexLightingStarSurface = (IntShaderProvider)manager.get("per-vertex-lighting-starsurface");
        IntShaderProvider perVertexLightingThruster = (IntShaderProvider)manager.get("per-vertex-lighting-thruster");
        IntShaderProvider perPixelLighting = (IntShaderProvider)manager.get("per-pixel-lighting");
        TessellationShaderProvider perPixelLightingTessellation = (TessellationShaderProvider)manager.get("per-pixel-lighting-tessellation");
        IntShaderProvider perPixelLightingDust = (IntShaderProvider)manager.get("per-pixel-lighting-dust");
        IntShaderProvider perPixelLightingDepth = (IntShaderProvider)manager.get("per-pixel-lighting-depth");
        IntShaderProvider perPixelLightingDepthTessellation = (IntShaderProvider)manager.get("per-pixel-lighting-depth-tessellation");
        IntShaderProvider perPixelLightingOpaque = (IntShaderProvider)manager.get("per-pixel-lighting-opaque");
        TessellationShaderProvider perPixelLightingOpaqueTessellation = (TessellationShaderProvider)manager.get("per-pixel-lighting-opaque-tessellation");
        IntShaderProvider perPixelLightingSvtDetection = (IntShaderProvider)manager.get("per-pixel-lighting-svtdetection");
        IntShaderProvider perPixelLightingSvtDetectionTessellation = (IntShaderProvider)manager.get("per-pixel-lighting-svtdetection-tessellation");
        IntShaderProvider skybox = (IntShaderProvider)manager.get("skybox");
        IntShaderProvider atmosphere = (IntShaderProvider)manager.get("atmosphere");
        IntShaderProvider cloud = (IntShaderProvider)manager.get("cloud");
        this.mbVertexLighting = new IntModelBatch(perVertexLighting);
        this.mbVertexLightingAdditive = new IntModelBatch(perVertexLightingAdditive);
        this.mbVertexDiffuse = new IntModelBatch(perVertexDiffuse);
        this.mbVertexLightingStarSurface = new IntModelBatch(perVertexLightingStarSurface);
        this.mbVertexLightingThruster = new IntModelBatch(perVertexLightingThruster);
        this.mbVertexLightingGrid = new IntModelBatch(perVertexLightingGrid);
        this.mbVertexLightingRecGrid = new IntModelBatch(perVertexLightingRecGrid);
        this.mbPixelLighting = new IntModelBatch(perPixelLighting);
        this.mbPixelLightingDust = new IntModelBatch(perPixelLightingDust);
        this.mbPixelLightingDepth = new IntModelBatch(perPixelLightingDepth);
        this.mbPixelLightingOpaque = new IntModelBatch(perPixelLightingOpaque);
        this.mbPixelLightingSvtDetection = new IntModelBatch(perPixelLightingSvtDetection);
        this.mbPixelLightingTessellation = new IntModelBatch(perPixelLightingTessellation);
        this.mbPixelLightingOpaqueTessellation = new IntModelBatch(perPixelLightingOpaqueTessellation);
        this.mbPixelLightingSvtDetectionTessellation = new IntModelBatch(perPixelLightingSvtDetectionTessellation);
        this.mbPixelLightingDepthTessellation = new IntModelBatch(perPixelLightingDepthTessellation);
        this.mbSkybox = new IntModelBatch(skybox);
        this.mbAtmosphere = new IntModelBatch(atmosphere);
        this.mbCloud = new IntModelBatch(cloud);
        this.fontDistanceFiled = (BitmapFont)manager.get("skins/fonts/font-distance-field.fnt");
        this.spriteBatch = this.globalResources.getExtSpriteBatch();
        this.spriteBatch.enableBlending();
        this.fontBatch = new ExtSpriteBatch(2000, this.distanceFieldFontShader);
        this.fontBatch.enableBlending();
        this.fontBatch.setBlendFunction(1, 1);
    }

    private AssetDescriptor<ExtShaderProgram>[] loadShader(AssetManager manager, String vertexShader, String fragmentShader, String[] names, String[] prepend) {
        return this.loadShader(manager, vertexShader, null, fragmentShader, names, prepend);
    }

    private AssetDescriptor<ExtShaderProgram>[] loadShader(AssetManager manager, String vertexShader, String geometryShader, String fragmentShader, String[] names, String[] prepend) {
        return this.loadShader(manager, vertexShader, geometryShader, fragmentShader, names, prepend, null);
    }

    private AssetDescriptor<ExtShaderProgram>[] loadShader(AssetManager manager, String vertexShader, String fragmentShader, String[] names, String[] prepend, String fixedPrepend) {
        return this.loadShader(manager, vertexShader, null, fragmentShader, names, prepend, fixedPrepend);
    }

    private AssetDescriptor<ExtShaderProgram>[] loadShader(AssetManager manager, String vertexShader, String geometryShader, String fragmentShader, String[] names, String[] prepend, String fixedPrepend) {
        AssetDescriptor[] result = new AssetDescriptor[prepend.length];
        int i = 0;
        for (String prep : prepend) {
            AssetDescriptor desc;
            ShaderProgramProvider.ShaderProgramParameter spp = new ShaderProgramProvider.ShaderProgramParameter();
            spp.name = names[i];
            spp.prependGeometryCode = spp.prependVertexCode = fixedPrepend != null ? fixedPrepend + "\n" + prep : prep;
            spp.prependFragmentCode = spp.prependVertexCode;
            spp.vertexFile = vertexShader;
            spp.geometryFile = geometryShader;
            spp.fragmentFile = fragmentShader;
            manager.load(names[i], ExtShaderProgram.class, (AssetLoaderParameters)spp);
            result[i] = desc = new AssetDescriptor(names[i], ExtShaderProgram.class, (AssetLoaderParameters)spp);
            ++i;
        }
        return result;
    }

    private ExtShaderProgram[] fetchShaderProgram(AssetManager manager, AssetDescriptor<ExtShaderProgram>[] descriptors, String ... names) {
        int n = descriptors.length;
        ExtShaderProgram[] shaders = new ExtShaderProgram[n];
        for (int i = 0; i < n; ++i) {
            shaders[i] = (ExtShaderProgram)manager.get(descriptors[i]);
            if (shaders[i].isLazy() || shaders[i].isCompiled()) continue;
            logger.error(I18n.msg("notif.shader.compile.fail.log", names[i], shaders[i].getLog()));
        }
        return shaders;
    }

    private ExtShaderProgram fetchShaderProgram(AssetManager manager, String descriptor, String name) {
        ExtShaderProgram shader = (ExtShaderProgram)manager.get(descriptor);
        if (!shader.isLazy() && !shader.isCompiled()) {
            logger.error(I18n.msg("notif.shader.compile.fail.log", name, shader.getLog()));
        }
        return shader;
    }
}

