/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render;

import com.badlogic.gdx.utils.Bits;

public enum RenderGroup {
    NONE(-100),
    SKYBOX(0),
    MODEL_BG(100),
    MODEL_VERT_GRID(200),
    POINT_STAR(300),
    FONT_ANNOTATION(400),
    MODEL_PIX_DUST(500),
    MODEL_PIX_EARLY(600),
    MODEL_VERT_EARLY(700),
    BILLBOARD_GROUP(800),
    PARTICLE_GROUP(1000),
    PARTICLE_GROUP_EXT_BILLBOARD(1100),
    PARTICLE_GROUP_EXT_MODEL(1110),
    STAR_GROUP(1300),
    VARIABLE_GROUP(1400),
    ORBITAL_ELEMENTS_PARTICLE(1500),
    ORBITAL_ELEMENTS_GROUP(1600),
    MODEL_DIFFUSE(1700),
    MODEL_PIX(1800),
    MODEL_PIX_TESS(1900),
    MODEL_VERT_STAR(2100),
    VOLUME(2110),
    FONT_LABEL(2200),
    MODEL_VERT_RECGRID(2500),
    POINT(3000),
    POINT_GPU(3100),
    LINE(4000),
    LINE_GPU(4100),
    BILLBOARD_SSO(5000),
    BILLBOARD_SPRITE(5300),
    BILLBOARD_GAL(5400),
    BILLBOARD_STAR(5500),
    MODEL_ATM(6000),
    MODEL_CLOUD(6500),
    MODEL_PIX_TRANSPARENT(7000),
    LINE_LATE(8000),
    SHAPE(9000),
    PARTICLE_EFFECTS(10000),
    MODEL_VERT_ADDITIVE(11000),
    SPRITE(12000);

    public final int priority;

    private RenderGroup(int priority) {
        this.priority = priority;
    }

    public static Bits add(Bits renderGroupMask, RenderGroup ... rgs) {
        for (RenderGroup rg : rgs) {
            renderGroupMask.set(rg.ordinal());
        }
        return renderGroupMask;
    }

    public static Bits set(Bits renderGroupMask, RenderGroup ... rgs) {
        renderGroupMask.clear();
        return RenderGroup.add(renderGroupMask, rgs);
    }

    public boolean is(Bits renderGroupMask) {
        return renderGroupMask.get(this.ordinal());
    }

    public boolean isPoint() {
        return this.equals((Object)POINT) || this.equals((Object)POINT_GPU);
    }

    public boolean isLine() {
        return this.equals((Object)LINE) || this.equals((Object)LINE_GPU) || this.equals((Object)LINE_LATE);
    }
}

