/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render;

import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import gaiasky.render.api.IPostProcessor;
import gaiasky.util.math.Vector3D;

public class RenderingContext {
    private static final float REFERENCE_SIZE = 2000.0f;
    public IPostProcessor.PostProcessBean ppb;
    public FrameBuffer fb;
    public Vector3D vrOffset;
    public float scaleFactor;
    public CubemapSide cubemapSide = CubemapSide.SIDE_NONE;
    private int w;
    private int h;

    public int w() {
        return this.w;
    }

    public int h() {
        return this.h;
    }

    public void set(int w, int h) {
        if (w != this.w || h != this.h) {
            this.scaleFactor = (float)(h + w) / 2000.0f;
        }
        this.w = w;
        this.h = h;
    }

    public boolean isCubemap() {
        return this.cubemapSide != null && !this.cubemapSide.equals((Object)CubemapSide.SIDE_NONE);
    }

    public static enum CubemapSide {
        SIDE_UP,
        SIDE_DOWN,
        SIDE_RIGHT,
        SIDE_LEFT,
        SIDE_FRONT,
        SIDE_BACK,
        SIDE_NONE;

    }
}

