/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;

public class ScreenModeCmd
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(ScreenModeCmd.class);
    public static ScreenModeCmd instance;

    private ScreenModeCmd() {
        EventManager.instance.subscribe((IObserver)this, Event.SCREEN_MODE_CMD);
    }

    public static void initialize() {
        instance = new ScreenModeCmd();
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.SCREEN_MODE_CMD) {
            boolean toFullScreen = Settings.settings.graphics.fullScreen.active;
            if (toFullScreen) {
                boolean good;
                Graphics.Monitor m = Gdx.graphics.getPrimaryMonitor();
                Graphics.DisplayMode[] modes = Gdx.graphics.getDisplayModes(m);
                Graphics.DisplayMode myMode = null;
                for (Graphics.DisplayMode mode : modes) {
                    if (mode.height != Settings.settings.graphics.fullScreen.resolution[1] || mode.width != Settings.settings.graphics.fullScreen.resolution[0] || mode.refreshRate != Settings.settings.graphics.fullScreen.refreshRate || mode.bitsPerPixel != Settings.settings.graphics.fullScreen.bitDepth) continue;
                    myMode = mode;
                    break;
                }
                if (myMode == null) {
                    myMode = Gdx.graphics.getDisplayMode(m);
                    Settings.settings.graphics.fullScreen.resolution[0] = myMode.width;
                    Settings.settings.graphics.fullScreen.resolution[1] = myMode.height;
                }
                if (!(good = Gdx.graphics.setFullscreenMode(myMode))) {
                    logger.error(I18n.msg("notif.error", I18n.msg("gui.fullscreen")));
                }
            } else {
                int width = Settings.settings.graphics.resolution[0];
                int height = Settings.settings.graphics.resolution[1];
                boolean good = Gdx.graphics.setWindowedMode(width, height);
                if (!good) {
                    logger.error(I18n.msg("notif.error", I18n.msg("gui.windowed")));
                }
            }
            if (!GaiaSky.instance.isHeadless()) {
                Gdx.graphics.setVSync(Settings.settings.graphics.vsync);
            }
        }
    }
}

