/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.api;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.render.postprocess.PostProcessor;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.util.Logger;
import java.util.HashMap;
import java.util.Map;

public interface IPostProcessor
extends Disposable {
    public static final String DEFAULT_KEY = "%default%";

    public void initialize(AssetManager var1);

    public void doneLoading(AssetManager var1);

    public PostProcessBean getPostProcessBean(RenderType var1);

    public void resize(int var1, int var2, int var3, int var4);

    public void resizeImmediate(int var1, int var2, int var3, int var4);

    public boolean isEnabled(Class<? extends PostProcessorEffect> var1);

    public boolean isLightScatterEnabled();

    public boolean isLensFlareEnabled();

    public static class PostProcessBean {
        protected static Logger.Log logger = Logger.getLogger(PostProcessBean.class);
        public PostProcessor pp;
        public Map<Class<? extends PostProcessorEffect>, Map<String, PostProcessorEffect>> effects = new HashMap<Class<? extends PostProcessorEffect>, Map<String, PostProcessorEffect>>();

        public void add(PostProcessorEffect effect) {
            this.addEffect(IPostProcessor.DEFAULT_KEY, effect);
        }

        public PostProcessorEffect get(Class<? extends PostProcessorEffect> clazz) {
            return this.get(IPostProcessor.DEFAULT_KEY, clazz);
        }

        public void add(String key, PostProcessorEffect effect) {
            this.addEffect(key, effect);
        }

        private void addEffect(String key, PostProcessorEffect effect) {
            if (this.effects != null) {
                Map<String, PostProcessorEffect> l = this.effects.get(effect.getClass());
                if (l != null) {
                    l.put(key, effect);
                } else {
                    l = new HashMap<String, PostProcessorEffect>();
                    l.put(key, effect);
                    this.effects.put(effect.getClass(), l);
                }
                this.pp.addEffect(effect);
            } else {
                logger.error("Effects list not initialized!");
            }
        }

        public PostProcessorEffect get(String key, Class<? extends PostProcessorEffect> clazz) {
            Map<String, PostProcessorEffect> l = this.effects.get(clazz);
            if (l != null) {
                return l.get(key);
            }
            return null;
        }

        public Map<String, PostProcessorEffect> getAll(Class<? extends PostProcessorEffect> clazz) {
            return this.effects.get(clazz);
        }

        public void remove(Class<? extends PostProcessorEffect> clazz) {
            Map<String, PostProcessorEffect> l = this.getAll(clazz);
            if (l != null) {
                l.forEach((key, ppe) -> {
                    ppe.setEnabled(false);
                    this.pp.removeEffect((PostProcessorEffect)ppe);
                });
                l.clear();
                this.effects.remove(clazz);
            }
        }

        public void remove(String key, Class<? extends PostProcessorEffect> clazz) {
            Map<String, PostProcessorEffect> l = this.getAll(clazz);
            if (l != null) {
                if (l.containsKey(key)) {
                    PostProcessorEffect ppe = l.get(key);
                    ppe.setEnabled(false);
                    this.pp.removeEffect(ppe);
                }
                l.remove(key);
            }
        }

        public boolean capture() {
            return this.pp.capture();
        }

        public boolean captureCubemap() {
            return this.pp.captureCubemap();
        }

        public boolean captureVR() {
            return this.pp.captureVR();
        }

        public boolean captureNoClear() {
            return this.pp.captureNoClear();
        }

        public boolean captureNoClearCubemap() {
            return this.pp.captureNoClearCubemap();
        }

        public boolean captureNoClearReprojection() {
            return this.pp.captureNoClearReprojection();
        }

        public void render() {
            this.pp.render();
        }

        public FrameBuffer captureEnd() {
            return this.pp.captureEnd();
        }

        public void render(FrameBuffer destination) {
            this.pp.render(destination);
        }

        public void dispose(boolean cleanAllBuffers) {
            if (this.pp != null) {
                this.pp.dispose(cleanAllBuffers);
            }
        }

        public void dispose() {
            this.dispose(true);
        }
    }

    public static enum RenderType {
        screen(0),
        screenshot(1),
        frame(2);

        public final int index;

        private RenderType(int index) {
            this.index = index;
        }
    }
}

