/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.HdpiUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.render.api.IPostProcessor;
import gaiasky.render.postprocess.PipelineState;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.PostProcessorListener;
import gaiasky.render.postprocess.util.PingPongBuffer;
import gaiasky.render.util.GaiaSkyFrameBuffer;
import gaiasky.render.util.ItemsManager;
import gaiasky.util.Settings;
import java.util.function.IntSupplier;
import org.lwjgl.opengl.GL30;

public final class PostProcessor
implements Disposable {
    private static final Array<PingPongBuffer> buffers = new Array(2);
    public static boolean EnableQueryStates = false;
    public static PostProcessor currentPostProcessor;
    private static PipelineState pipelineState;
    private static Pixmap.Format pixmapFormat;
    private final PingPongBuffer composite;
    private final ItemsManager<PostProcessorEffect> effectsManager = new ItemsManager();
    private final Color clearColor = Color.CLEAR;
    private final Rectangle viewport = new Rectangle();
    private final boolean useDepth;
    private final Array<PostProcessorEffect> enabledEffects = new Array(5);
    private Texture.TextureWrap compositeWrapU;
    private Texture.TextureWrap compositeWrapV;
    private Texture.TextureFilter compositeMinFilter;
    private Texture.TextureFilter compositeMagFilter;
    private int clearBits = 16384;
    private float clearDepth = 1.0f;
    private boolean enabled;
    private boolean capturing;
    private boolean hasCaptured;
    private PostProcessorListener listener = null;

    public PostProcessor(IPostProcessor.RenderType rt, boolean useDepth, boolean useAlphaChannel, boolean use32Bits) {
        this(rt, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), useDepth, useAlphaChannel, use32Bits, false, false, true);
    }

    public PostProcessor(IPostProcessor.RenderType rt, int fboWidth, int fboHeight, boolean hasDepth, boolean useAlphaChannel, boolean use32Bits, boolean hasNormal, boolean hasReflectionMask, boolean preventFloatBuffer) {
        this(rt, fboWidth, fboHeight, hasDepth, useAlphaChannel, use32Bits, hasNormal, hasReflectionMask, preventFloatBuffer, Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
    }

    public PostProcessor(IPostProcessor.RenderType rt, int fboWidth, int fboHeight, boolean useDepth, boolean useAlphaChannel, boolean use32Bits, boolean hasNormal, boolean hasReflectionMask, boolean preventFloatBuffer, Texture.TextureWrap u, Texture.TextureWrap v) {
        pixmapFormat = use32Bits ? (useAlphaChannel ? Pixmap.Format.RGBA8888 : Pixmap.Format.RGB888) : (useAlphaChannel ? Pixmap.Format.RGBA4444 : Pixmap.Format.RGB565);
        this.composite = PostProcessor.newPingPongBuffer(fboWidth, fboHeight, pixmapFormat, useDepth, hasNormal, hasReflectionMask, preventFloatBuffer);
        this.setBufferTextureWrap(u, v);
        if (rt == IPostProcessor.RenderType.screen) {
            Settings.UpscaleFilter upscaleFilter = Settings.settings.postprocess.upscaleFilter;
            this.setBufferTextureFilter(upscaleFilter.minification, upscaleFilter.magnification);
        }
        pipelineState = new PipelineState();
        this.capturing = false;
        this.hasCaptured = false;
        this.enabled = true;
        this.useDepth = useDepth;
        if (useDepth) {
            this.clearBits |= 0x100;
        }
        this.setViewport(null);
    }

    public static PingPongBuffer newPingPongBuffer(int width, int height, Pixmap.Format frameBufferFormat, boolean hasDepth) {
        return PostProcessor.newPingPongBuffer(width, height, frameBufferFormat, hasDepth, false, false, true);
    }

    public static PingPongBuffer newPingPongBuffer(int width, int height, Pixmap.Format pixmapFormat, boolean hasDepth, boolean hasNormal, boolean hasReflectionMask, boolean preventFloatBuffer) {
        PingPongBuffer buffer = new PingPongBuffer(width, height, pixmapFormat, hasDepth, hasNormal, hasReflectionMask, preventFloatBuffer);
        buffers.add((Object)buffer);
        return buffer;
    }

    public static boolean isStateEnabled(int pname) {
        if (EnableQueryStates) {
            return pipelineState.isEnabled(pname);
        }
        return false;
    }

    public static Pixmap.Format getFramebufferFormat() {
        return pixmapFormat;
    }

    public Rectangle getViewport() {
        return this.viewport;
    }

    public void setViewport(Rectangle viewport) {
        if (viewport != null) {
            this.viewport.set(viewport);
        }
    }

    public void dispose() {
        this.dispose(true);
    }

    public void dispose(boolean cleanAllBuffers) {
        this.effectsManager.dispose();
        if (cleanAllBuffers) {
            for (int i = 0; i < PostProcessor.buffers.size; ++i) {
                ((PingPongBuffer)buffers.get(i)).dispose();
            }
            buffers.clear();
        } else {
            this.composite.dispose();
            buffers.removeValue((Object)this.composite, true);
        }
        this.enabledEffects.clear();
        if (cleanAllBuffers) {
            pipelineState.dispose();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isReady() {
        boolean hasEffects = false;
        for (PostProcessorEffect e : this.effectsManager) {
            if (!e.isEnabled()) continue;
            hasEffects = true;
            break;
        }
        return this.enabled && !this.capturing && hasEffects;
    }

    public int getEnabledEffectsCount() {
        return this.enabledEffects.size;
    }

    public void setListener(PostProcessorListener listener) {
        this.listener = listener;
    }

    public void addEffect(PostProcessorEffect effect) {
        this.effectsManager.add(effect);
    }

    public void removeEffect(PostProcessorEffect effect) {
        this.effectsManager.remove(effect);
    }

    public void setClearColor(Color color) {
        this.clearColor.set(color);
    }

    public void setClearColor(float r, float g, float b, float a) {
        this.clearColor.set(r, g, b, a);
    }

    public void setClearBits(int bits) {
        this.clearBits = bits;
    }

    public void setClearDepth(float depth) {
        this.clearDepth = depth;
    }

    public void setBufferTextureFilter(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
        this.compositeMinFilter = minFilter;
        this.compositeMagFilter = magFilter;
        this.composite.texture1.setFilter(minFilter, magFilter);
        this.composite.texture2.setFilter(minFilter, magFilter);
    }

    public void setBufferTextureWrap(Texture.TextureWrap u, Texture.TextureWrap v) {
        this.compositeWrapU = u;
        this.compositeWrapV = v;
        this.composite.texture1.setWrap(this.compositeWrapU, this.compositeWrapV);
        this.composite.texture2.setWrap(this.compositeWrapU, this.compositeWrapV);
    }

    public boolean capture() {
        return this.capture(this::buildEnabledEffectsList);
    }

    public boolean captureCubemap() {
        return this.capture(this::buildEnabledEffectsListCubemap);
    }

    public boolean captureVR() {
        return this.capture(this::buildEnabledEffectsListVR);
    }

    public boolean capture(IntSupplier supplier) {
        this.hasCaptured = false;
        if (this.enabled && !this.capturing) {
            if (supplier.getAsInt() == 0) {
                return false;
            }
            this.capturing = true;
            this.composite.getMainBuffer().begin();
            if (this.useDepth) {
                Gdx.gl.glClearDepthf(this.clearDepth);
            }
            Gdx.gl.glClearColor(this.clearColor.r, this.clearColor.g, this.clearColor.b, this.clearColor.a);
            Gdx.gl.glClear(this.clearBits);
            return true;
        }
        return false;
    }

    public boolean captureNoClear() {
        return this.captureNoClear(this::buildEnabledEffectsList);
    }

    public boolean captureNoClearCubemap() {
        return this.captureNoClear(this::buildEnabledEffectsListCubemap);
    }

    public boolean captureNoClearReprojection() {
        return this.captureNoClear(this::buildEnabledEffectsListVR);
    }

    public boolean captureNoClear(IntSupplier supplier) {
        this.hasCaptured = false;
        if (this.enabled && !this.capturing) {
            if (supplier.getAsInt() == 0) {
                return false;
            }
            this.capturing = true;
            this.composite.begin();
            this.composite.capture();
            return true;
        }
        return false;
    }

    public GaiaSkyFrameBuffer captureEnd() {
        if (this.enabled && this.capturing) {
            this.capturing = false;
            this.hasCaptured = true;
            this.composite.getMainBuffer().end();
            return this.composite.getMainBuffer();
        }
        return null;
    }

    public PingPongBuffer getCombinedBuffer() {
        return this.composite;
    }

    public void rebind() {
        this.composite.texture1.setWrap(this.compositeWrapU, this.compositeWrapV);
        this.composite.texture2.setWrap(this.compositeWrapU, this.compositeWrapV);
        this.composite.texture1.setFilter(this.compositeMinFilter, this.compositeMagFilter);
        this.composite.texture2.setFilter(this.compositeMinFilter, this.compositeMagFilter);
        for (int i = 0; i < PostProcessor.buffers.size; ++i) {
            ((PingPongBuffer)buffers.get(i)).rebind();
        }
        for (PostProcessorEffect e : this.effectsManager) {
            e.rebind();
        }
    }

    void copyFrameBufferTexture(int width, int height, FrameBuffer fbIn, FrameBuffer fbOut) {
        GL30.glBindFramebuffer((int)36008, (int)fbIn.getFramebufferHandle());
        GL30.glFramebufferTexture2D((int)36008, (int)36064, (int)3553, (int)((Texture)fbIn.getColorBufferTexture()).glTarget, (int)0);
        GL30.glReadBuffer((int)36064);
        GL30.glBindFramebuffer((int)36009, (int)fbOut.getFramebufferHandle());
        GL30.glFramebufferTexture2D((int)36009, (int)36065, (int)3553, (int)((Texture)fbOut.getColorBufferTexture()).glTarget, (int)0);
        GL30.glDrawBuffer((int)36065);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)width, (int)height, (int)0, (int)0, (int)width, (int)height, (int)16384, (int)9728);
        GL30.glFramebufferTexture2D((int)36160, (int)36065, (int)3553, (int)0, (int)0);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)0, (int)0);
    }

    public void render(FrameBuffer destination) {
        this.captureEnd();
        if (!this.hasCaptured) {
            return;
        }
        Array<PostProcessorEffect> items = this.enabledEffects;
        int count = items.size;
        if (count > 0) {
            currentPostProcessor = this;
            Gdx.gl.glDisable(2884);
            Gdx.gl.glDisable(2929);
            if (count > 1) {
                for (int i = 0; i < count - 1; ++i) {
                    PostProcessorEffect e = (PostProcessorEffect)items.get(i);
                    this.composite.capture();
                    GaiaSkyFrameBuffer source = i == 0 ? this.composite.getMainBuffer() : this.composite.getSourceBuffer();
                    e.render(source, this.composite.getResultBuffer(), this.composite.getMainBuffer());
                }
                this.composite.end();
            }
            currentPostProcessor = null;
            if (this.listener != null && destination == null) {
                this.listener.beforeRenderToScreen();
            }
            ((PostProcessorEffect)items.get(count - 1)).render(this.composite.getResultBuffer(), destination, this.composite.getMainBuffer());
            Gdx.gl.glActiveTexture(33984);
        } else {
            Gdx.app.log("PostProcessor", "No post-processor effects enabled, aborting render");
        }
    }

    public void render() {
        this.render(null);
    }

    public int buildEnabledEffectsList(boolean cubemap, boolean reprojection) {
        if (cubemap) {
            return this.buildEnabledEffectsListCubemap();
        }
        if (reprojection) {
            return this.buildEnabledEffectsListVR();
        }
        return this.buildEnabledEffectsList();
    }

    public int buildEnabledEffectsList() {
        this.enabledEffects.clear();
        for (PostProcessorEffect e : this.effectsManager) {
            if (!e.isEnabled()) continue;
            this.enabledEffects.add((Object)e);
        }
        return this.enabledEffects.size;
    }

    public int buildEnabledEffectsListCubemap() {
        this.enabledEffects.clear();
        for (PostProcessorEffect e : this.effectsManager) {
            if (!e.isEnabled() || !e.isEnabledInCubemap()) continue;
            this.enabledEffects.add((Object)e);
        }
        return this.enabledEffects.size;
    }

    public int buildEnabledEffectsListVR() {
        this.enabledEffects.clear();
        for (PostProcessorEffect e : this.effectsManager) {
            if (!e.isEnabled() || !e.isEnabledInVR()) continue;
            this.enabledEffects.add((Object)e);
        }
        return this.enabledEffects.size;
    }

    void restoreViewport(FrameBuffer dest) {
        if (dest == null) {
            HdpiUtils.glViewport((int)((int)this.viewport.x), (int)((int)this.viewport.y), (int)((int)this.viewport.width), (int)((int)this.viewport.height));
        }
    }

    static {
        pipelineState = null;
    }
}

