/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess;

import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.render.postprocess.PostProcessor;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public abstract class PostProcessorEffect
implements Disposable {
    protected boolean enabled = true;
    protected boolean enabledInCubemap = true;
    protected boolean enabledInVR = true;
    protected Array<Disposable> disposables = new Array(1);
    protected boolean disposed = false;

    public abstract void rebind();

    public abstract void render(FrameBuffer var1, FrameBuffer var2, GaiaSkyFrameBuffer var3);

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabledInCubemap() {
        return this.enabledInCubemap;
    }

    public boolean isEnabledInVR() {
        return this.enabledInVR;
    }

    public void setEnabledOptions(boolean enabledInCubemap, boolean enabledInVR) {
        this.enabledInCubemap = enabledInCubemap;
        this.enabledInVR = enabledInVR;
    }

    public void setEnabledInCubemap(boolean enabled) {
        this.enabledInCubemap = enabled;
    }

    public void setEnabledInVR(boolean enabled) {
        this.enabledInVR = enabled;
    }

    protected void restoreViewport(FrameBuffer dest) {
        if (PostProcessor.currentPostProcessor != null) {
            PostProcessor.currentPostProcessor.restoreViewport(dest);
        }
    }

    public void updateShaders() {
    }

    public void dispose() {
        if (!this.disposed) {
            for (Disposable disposable : this.disposables) {
                if (disposable == null) continue;
                disposable.dispose();
            }
            this.disposables.clear();
            this.disposed = true;
        }
    }
}

