/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.AccumulationBlurFilter;
import gaiasky.render.postprocess.filters.CopyFilter;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public class AccumulationBlur
extends PostProcessorEffect {
    private final CopyFilter copyFilter;
    private final AccumulationBlurFilter motionFilter = new AccumulationBlurFilter();
    private final FrameBuffer fbo;

    public AccumulationBlur(int width, int height) {
        this.motionFilter.setResolution(width, height);
        this.copyFilter = new CopyFilter();
        this.fbo = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, false);
        this.disposables.addAll((Object[])new Disposable[]{this.copyFilter, this.motionFilter, this.fbo});
    }

    public void setBlurOpacity(float blurOpacity) {
        this.motionFilter.setBlurOpacity(blurOpacity);
    }

    public void setBlurRadius(float blurRadius) {
        this.motionFilter.setBlurRadius(blurRadius);
    }

    public void setResolution(int w, int h) {
        this.motionFilter.setResolution(w, h);
    }

    @Override
    public void rebind() {
        this.motionFilter.rebind();
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        this.restoreViewport(dest);
        if (dest != null) {
            ((AccumulationBlurFilter)((AccumulationBlurFilter)this.motionFilter.setInput(src)).setOutput(dest)).render();
        } else {
            ((AccumulationBlurFilter)((AccumulationBlurFilter)this.motionFilter.setInput(src)).setOutput(this.fbo)).render();
            ((CopyFilter)((CopyFilter)this.copyFilter.setInput(this.fbo)).setOutput(dest)).render();
        }
        this.motionFilter.setLastFrameTexture((Texture)this.fbo.getColorBufferTexture());
    }
}

