/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.render.postprocess.PostProcessor;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.BlurFilter;
import gaiasky.render.postprocess.filters.CombineFilter;
import gaiasky.render.postprocess.filters.ThresholdFilter;
import gaiasky.render.postprocess.util.PingPongBuffer;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public final class Bloom
extends PostProcessorEffect {
    private final PingPongBuffer pingPongBuffer;
    private final BlurFilter blurFilter;
    private final ThresholdFilter thresholdFilter;
    private final CombineFilter combineFilter;
    private boolean blending = false;
    private int sFactor;
    private int dFactor;

    public Bloom(int fboWidth, int fboHeight) {
        this.pingPongBuffer = PostProcessor.newPingPongBuffer(fboWidth, fboHeight, Pixmap.Format.RGB888, false, false, false, false);
        this.blurFilter = new BlurFilter(fboWidth, fboHeight);
        this.thresholdFilter = new ThresholdFilter();
        this.combineFilter = new CombineFilter();
        this.disposables.addAll((Object[])new Disposable[]{this.blurFilter, this.thresholdFilter, this.combineFilter, this.pingPongBuffer});
        this.blurFilter.setAmount(0.0f);
        this.blurFilter.setPasses(3);
        this.blurFilter.setType(BlurFilter.BlurType.Gaussian5x5b);
        this.setThreshold(0.3f);
        this.setBaseIntensity(1.0f);
        this.setBaseSaturation(0.85f);
        this.setBloomIntesnity(1.1f);
        this.setBloomSaturation(0.85f);
    }

    public void setBaseIntensity(float intensity) {
        this.combineFilter.setSource1Intensity(intensity);
    }

    public void setBaseSaturation(float saturation) {
        this.combineFilter.setSource1Saturation(saturation);
    }

    public void setBloomIntesnity(float intensity) {
        this.combineFilter.setSource2Intensity(intensity);
    }

    public void setBloomSaturation(float saturation) {
        this.combineFilter.setSource2Saturation(saturation);
    }

    public void enableBlending(int sfactor, int dfactor) {
        this.blending = true;
        this.sFactor = sfactor;
        this.dFactor = dfactor;
    }

    public void disableBlending() {
        this.blending = false;
    }

    public float getThreshold() {
        return this.thresholdFilter.getThreshold();
    }

    public void setThreshold(float threshold) {
        this.thresholdFilter.setThreshold(threshold);
    }

    public BlurFilter.BlurType getBlurType() {
        return this.blurFilter.getType();
    }

    public void setBlurType(BlurFilter.BlurType type) {
        this.blurFilter.setType(type);
    }

    public int getBlurPasses() {
        return this.blurFilter.getPasses();
    }

    public void setBlurPasses(int passes) {
        this.blurFilter.setPasses(passes);
    }

    public float getBlurAmount() {
        return this.blurFilter.getAmount();
    }

    public void setBlurAmount(float amount) {
        this.blurFilter.setAmount(amount);
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        Texture texsrc = (Texture)src.getColorBufferTexture();
        boolean blendingWasEnabled = PostProcessor.isStateEnabled(3042);
        Gdx.gl.glDisable(3042);
        this.pingPongBuffer.begin();
        ((ThresholdFilter)((ThresholdFilter)this.thresholdFilter.setInput(texsrc)).setOutput(this.pingPongBuffer.getSourceBuffer())).render();
        this.blurFilter.render(this.pingPongBuffer);
        this.pingPongBuffer.end();
        if (this.blending || blendingWasEnabled) {
            Gdx.gl.glEnable(3042);
        }
        if (this.blending) {
            Gdx.gl.glBlendFunc(this.sFactor, this.dFactor);
        }
        this.restoreViewport(dest);
        ((CombineFilter)this.combineFilter.setOutput(dest)).setInput(texsrc, this.pingPongBuffer.getResultTexture()).render();
    }

    @Override
    public void rebind() {
        this.blurFilter.rebind();
        this.thresholdFilter.rebind();
        this.combineFilter.rebind();
        this.pingPongBuffer.rebind();
    }

    public static class Settings {
        public final String name;
        public final BlurFilter.BlurType blurType;
        public final int blurPasses;
        public final float blurAmount;
        public final float bloomThreshold;
        public final float bloomIntensity;
        public final float bloomSaturation;
        public final float baseIntensity;
        public final float baseSaturation;

        public Settings(String name, BlurFilter.BlurType blurType, int blurPasses, float blurAmount, float bloomThreshold, float baseIntensity, float baseSaturation, float bloomIntensity, float bloomSaturation) {
            this.name = name;
            this.blurType = blurType;
            this.blurPasses = blurPasses;
            this.blurAmount = blurAmount;
            this.bloomThreshold = bloomThreshold;
            this.baseIntensity = baseIntensity;
            this.baseSaturation = baseSaturation;
            this.bloomIntensity = bloomIntensity;
            this.bloomSaturation = bloomSaturation;
        }

        public Settings(String name, int blurPasses, float bloomThreshold, float baseIntensity, float baseSaturation, float bloomIntensity, float bloomSaturation) {
            this(name, BlurFilter.BlurType.Gaussian5x5, blurPasses, 0.0f, bloomThreshold, baseIntensity, baseSaturation, bloomIntensity, bloomSaturation);
        }

        public Settings(Settings other) {
            this.name = other.name;
            this.blurType = other.blurType;
            this.blurPasses = other.blurPasses;
            this.blurAmount = other.blurAmount;
            this.bloomThreshold = other.bloomThreshold;
            this.baseIntensity = other.baseIntensity;
            this.baseSaturation = other.baseSaturation;
            this.bloomIntensity = other.bloomIntensity;
            this.bloomSaturation = other.bloomSaturation;
        }
    }
}

