/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.CameraMotionBlurFilter;
import gaiasky.render.util.GaiaSkyFrameBuffer;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.Constants;

public final class CameraMotionBlur
extends PostProcessorEffect {
    private final CameraMotionBlurFilter cameraMotionBlurFilter;
    private final float width;
    private final float height;
    private final Vector3 aux = new Vector3();

    public CameraMotionBlur(float width, float height) {
        this.width = width;
        this.height = height;
        this.cameraMotionBlurFilter = new CameraMotionBlurFilter();
        this.disposables.add((Object)this.cameraMotionBlurFilter);
    }

    public void setBlurMaxSamples(int samples) {
        this.cameraMotionBlurFilter.setBlurMaxSamples(samples);
    }

    public void setBlurScale(float scale) {
        this.cameraMotionBlurFilter.setBlurScale(scale);
    }

    @Override
    public void rebind() {
        this.cameraMotionBlurFilter.rebind();
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        if (dest != null) {
            this.cameraMotionBlurFilter.setViewport(dest.getWidth(), dest.getHeight());
        } else {
            this.cameraMotionBlurFilter.setViewport(this.width, this.height);
        }
        ICamera cam = GaiaSky.instance.getICamera();
        cam.getDPos().put(this.aux);
        this.cameraMotionBlurFilter.setDCam(this.aux.scl(1.0f / (float)cam.getSpeedScalingCapped()));
        this.cameraMotionBlurFilter.setZFarK((float)cam.getFar(), Constants.getCameraK());
        this.cameraMotionBlurFilter.setProjView(cam.getProjView());
        this.cameraMotionBlurFilter.setPrevProjView(cam.getPreviousProjView());
        this.restoreViewport(dest);
        this.cameraMotionBlurFilter.setDepthTexture(main.getDepthBufferTexture());
        ((CameraMotionBlurFilter)((CameraMotionBlurFilter)this.cameraMotionBlurFilter.setInput(src)).setOutput(dest)).render();
    }
}

