/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.render.postprocess.PostProcessor;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.BlurFilter;
import gaiasky.render.postprocess.filters.CombineFilter;
import gaiasky.render.postprocess.filters.CrtScreenFilter;
import gaiasky.render.postprocess.util.PingPongBuffer;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public final class CrtMonitor
extends PostProcessorEffect {
    private final CrtScreenFilter crt;
    private final CombineFilter combineFilter;
    private PingPongBuffer pingPongBuffer = null;
    private FrameBuffer buffer = null;
    private BlurFilter blurFilter;
    private boolean blending = false;
    private int sFactor;
    private int dFactor;

    public CrtMonitor(int fboWidth, int fboHeight, boolean barrelDistortion, boolean performBlur, CrtScreenFilter.RgbMode mode, int effectsSupport) {
        if (performBlur) {
            this.pingPongBuffer = PostProcessor.newPingPongBuffer(fboWidth, fboHeight, Pixmap.Format.RGB888, false, false, false, false);
            this.blurFilter = new BlurFilter(fboWidth, fboHeight);
            this.blurFilter.setPasses(1);
            this.blurFilter.setAmount(1.0f);
            this.blurFilter.setType(BlurFilter.BlurType.Gaussian3x3);
            this.disposables.addAll((Object[])new Disposable[]{this.pingPongBuffer, this.blurFilter});
        } else {
            this.buffer = new FrameBuffer(PostProcessor.getFramebufferFormat(), fboWidth, fboHeight, false);
            this.disposables.addAll((Object[])new Disposable[]{this.buffer});
        }
        this.combineFilter = new CombineFilter();
        this.crt = new CrtScreenFilter(barrelDistortion, mode, effectsSupport);
        this.disposables.addAll((Object[])new Disposable[]{this.combineFilter, this.crt});
    }

    public void enableBlending(int sFactor, int dFactor) {
        this.blending = true;
        this.sFactor = sFactor;
        this.dFactor = dFactor;
    }

    public void disableBlending() {
        this.blending = false;
    }

    public void setTime(float elapsedSecs) {
        this.crt.setTime(elapsedSecs);
    }

    public void setColorOffset(float offset) {
        this.crt.setColorOffset(offset);
    }

    public void setChromaticDispersion(float redCyan, float blueYellow) {
        this.crt.setChromaticDispersion(redCyan, blueYellow);
    }

    public void setChromaticDispersionRC(float redCyan) {
        this.crt.setChromaticDispersionRC(redCyan);
    }

    public void setChromaticDispersionBY(float blueYellow) {
        this.crt.setChromaticDispersionBY(blueYellow);
    }

    public void setTint(float r, float g, float b) {
        this.crt.setTint(r, g, b);
    }

    public void setDistortion(float distortion) {
        this.crt.setDistortion(distortion);
    }

    public CombineFilter getCombinePass() {
        return this.combineFilter;
    }

    public float getOffset() {
        return this.crt.getOffset();
    }

    public Vector2 getChromaticDispersion() {
        return this.crt.getChromaticDispersion();
    }

    public float getZoom() {
        return this.crt.getZoom();
    }

    public void setZoom(float zoom) {
        this.crt.setZoom(zoom);
    }

    public Color getTint() {
        return this.crt.getTint();
    }

    public void setTint(Color tint) {
        this.crt.setTint(tint);
    }

    public CrtScreenFilter.RgbMode getRgbMode() {
        return this.crt.getRgbMode();
    }

    public void setRgbMode(CrtScreenFilter.RgbMode mode) {
        this.crt.setRgbMode(mode);
    }

    @Override
    public void rebind() {
        this.crt.rebind();
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        Texture out;
        Texture in = (Texture)src.getColorBufferTexture();
        boolean blendingWasEnabled = PostProcessor.isStateEnabled(3042);
        Gdx.gl.glDisable(3042);
        if (this.blurFilter != null) {
            this.pingPongBuffer.begin();
            ((CrtScreenFilter)((CrtScreenFilter)this.crt.setInput(in)).setOutput(this.pingPongBuffer.getSourceBuffer())).render();
            this.blurFilter.render(this.pingPongBuffer);
            this.pingPongBuffer.end();
            out = this.pingPongBuffer.getResultTexture();
        } else {
            ((CrtScreenFilter)((CrtScreenFilter)this.crt.setInput(in)).setOutput(this.buffer)).render();
            out = (Texture)this.buffer.getColorBufferTexture();
        }
        if (this.blending || blendingWasEnabled) {
            Gdx.gl.glEnable(3042);
        }
        if (this.blending) {
            Gdx.gl.glBlendFunc(this.sFactor, this.dFactor);
        }
        this.restoreViewport(dest);
        ((CombineFilter)this.combineFilter.setOutput(dest)).setInput(in, out).render();
    }
}

