/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.CubemapProjectionsFilter;
import gaiasky.render.util.GaiaSkyFrameBuffer;
import java.util.function.Function;

public final class CubmeapProjectionEffect
extends PostProcessorEffect {
    private final CubemapProjectionsFilter filter;

    public CubmeapProjectionEffect(float w, float h) {
        this.filter = new CubemapProjectionsFilter(w, h);
        this.disposables.add((Object)this.filter);
    }

    @Override
    public void rebind() {
        this.filter.rebind();
    }

    public void setSides(FrameBuffer xpositive, FrameBuffer xnegative, FrameBuffer ypositive, FrameBuffer ynegative, FrameBuffer zpositive, FrameBuffer znegative) {
        this.filter.setSides(xpositive, xnegative, ypositive, ynegative, zpositive, znegative);
    }

    public void setViewportSize(float w, float h) {
        this.filter.setViewportSize(w, h);
    }

    public float getPlanetariumAngle() {
        return this.filter.getPlanetariumAngle();
    }

    public void setPlanetariumAngle(float angle) {
        this.filter.setPlanetariumAngle(angle);
    }

    public float getPlanetariumAperture() {
        return this.filter.getPlanetariumAperture();
    }

    public void setPlanetariumAperture(float ap) {
        this.filter.setPlanetariumAperture(ap);
    }

    public float getCelestialSphereIndexOfRefraction() {
        return this.filter.getCelestialSphereIndexOfRefraction();
    }

    public void setCelestialSphereIndexOfRefraction(float ior) {
        this.filter.setCelestialSphereIndexOfRefraction(ior);
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        this.restoreViewport(dest);
        ((CubemapProjectionsFilter)((CubemapProjectionsFilter)this.filter.setInput(src)).setOutput(dest)).render();
    }

    public CubemapProjection getProjection() {
        return this.filter.getProjection();
    }

    public void setProjection(CubemapProjection projection) {
        this.filter.setProjection(projection);
    }

    public static enum CubemapProjection {
        EQUIRECTANGULAR,
        CYLINDRICAL,
        HAMMER,
        ORTHOGRAPHIC,
        ORTHOSPHERE,
        ORTHOSPHERE_CROSSEYE,
        AZIMUTHAL_EQUIDISTANT,
        SPHERICAL_MIRROR;


        public boolean isPlanetarium() {
            return this.isAzimuthalEquidistant() || this.isSphericalMirror();
        }

        public boolean isDomeMaster() {
            return this.isAzimuthalEquidistant();
        }

        public boolean isFisheye() {
            return this.isAzimuthalEquidistant();
        }

        public boolean isAzimuthalEquidistant() {
            return this.equals((Object)AZIMUTHAL_EQUIDISTANT);
        }

        public boolean isSphericalMirror() {
            return this.equals((Object)SPHERICAL_MIRROR);
        }

        public boolean isOrthosphere() {
            return this.equals((Object)ORTHOSPHERE) || this.equals((Object)ORTHOSPHERE_CROSSEYE);
        }

        public boolean isPanorama() {
            return !this.isPlanetarium() && !this.isOrthosphere();
        }

        public CubemapProjection getNextPlanetariumProjection() {
            return this.getNext(CubemapProjection::isPlanetarium);
        }

        public CubemapProjection getNextPanoramaProjection() {
            return this.getNext(CubemapProjection::isPanorama);
        }

        public CubemapProjection getNextOrthosphereProfile() {
            return this.getNext(CubemapProjection::isOrthosphere);
        }

        public CubemapProjection getNext(Function<CubemapProjection, Boolean> supplier) {
            CubemapProjection proj;
            int n = CubemapProjection.values().length;
            int i = this.ordinal();
            do {
                i = (i + 1) % n;
            } while (!supplier.apply(proj = CubemapProjection.values()[i]).booleanValue());
            return proj;
        }
    }
}

