/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.render.postprocess.PostProcessor;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.CombineFilter;
import gaiasky.render.postprocess.filters.LensDirtFilter;
import gaiasky.render.postprocess.filters.LensFlareFilter;
import gaiasky.render.postprocess.util.PingPongBuffer;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public class LensFlare
extends PostProcessorEffect {
    private final PingPongBuffer pingPongBuffer;
    private final LensFlareFilter flare;
    private LensDirtFilter dirt;
    private final CombineFilter combineFilter;
    private final boolean useLensDirt;

    public LensFlare(int width, int height, float intensity, int type, boolean useLensDirt) {
        this.useLensDirt = useLensDirt;
        this.flare = new LensFlareFilter(width, height, intensity, type, useLensDirt);
        this.pingPongBuffer = PostProcessor.newPingPongBuffer(width, height, Pixmap.Format.RGB888, false, false, false, false);
        this.combineFilter = new CombineFilter();
        this.disposables.addAll((Object[])new Disposable[]{this.flare, this.pingPongBuffer, this.combineFilter});
        if (useLensDirt) {
            this.dirt = new LensDirtFilter();
            this.disposables.add((Object)this.dirt);
        }
    }

    public void setViewport(int width, int height) {
        this.flare.setViewportSize(width, height);
    }

    public void setLightPositions(int nLights, float[] positions, float[] intensities) {
        this.flare.setLightPositions(nLights, positions, intensities);
    }

    public void setIntensity(float intensity) {
        this.flare.setIntensity(intensity);
    }

    public void setColor(float[] color) {
        this.flare.setColor(color);
    }

    public void setLensDirtTexture(Texture tex) {
        if (this.useLensDirt) {
            this.dirt.setLensDirtTexture(tex);
        }
    }

    public void setLensStarburstTexture(Texture tex) {
        if (this.useLensDirt) {
            this.dirt.setLensStarburstTexture(tex);
        }
    }

    public void setStarburstOffset(float offset) {
        if (this.useLensDirt) {
            this.dirt.setStarburstOffset(offset);
        }
    }

    @Override
    public void updateShaders() {
        super.updateShaders();
        this.flare.updateProgram();
        if (this.useLensDirt) {
            this.dirt.updateProgram();
        }
    }

    @Override
    public void rebind() {
        this.flare.rebind();
        this.combineFilter.rebind();
        this.pingPongBuffer.rebind();
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        boolean blendingWasEnabled = PostProcessor.isStateEnabled(3042);
        Gdx.gl.glDisable(3042);
        Texture sourceTexture = (Texture)src.getColorBufferTexture();
        this.pingPongBuffer.begin();
        if (this.useLensDirt) {
            ((LensFlareFilter)((LensFlareFilter)this.flare.setInput(sourceTexture)).setOutput(this.pingPongBuffer.getSourceBuffer())).render();
            ((LensDirtFilter)((LensDirtFilter)this.dirt.setInput(this.pingPongBuffer.getSourceBuffer())).setOutput(this.pingPongBuffer.getResultBuffer())).render();
        } else {
            ((LensFlareFilter)((LensFlareFilter)this.flare.setInput(sourceTexture)).setOutput(this.pingPongBuffer.getResultBuffer())).render();
        }
        this.pingPongBuffer.end();
        if (blendingWasEnabled) {
            Gdx.gl.glEnable(3042);
        }
        this.restoreViewport(dest);
        ((CombineFilter)this.combineFilter.setInput(sourceTexture, this.pingPongBuffer.getResultTexture()).setOutput(dest)).render();
    }
}

