/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.GaiaSky;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.LevelsFilter;
import gaiasky.render.postprocess.filters.LumaFilter;
import gaiasky.render.util.GaiaSkyFrameBuffer;
import gaiasky.util.Settings;
import java.nio.FloatBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jafama.FastMath;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL30;

public final class Levels
extends PostProcessorEffect {
    private static final int LUMA_SIZE = 200;
    private final LumaFilter lumaFilter;
    private final FrameBuffer lumaBuffer;
    private final AtomicBoolean processRunning;
    FloatBuffer pixels = BufferUtils.createFloatBuffer((int)120000);
    private final LevelsFilter levels = new LevelsFilter();
    private float lumaMax = 0.9f;
    private float lumaAvg = 0.09f;
    private float currLumaMax = -1.0f;
    private float currLumaAvg = -1.0f;
    private long lastFrame = -10L;

    public Levels() {
        this.lumaFilter = new LumaFilter();
        this.processRunning = new AtomicBoolean(false);
        int size = 200;
        while (size > 1) {
            size = (int)FastMath.floor((float)((float)size / 2.0f));
        }
        GLFrameBuffer.FrameBufferBuilder builder = new GLFrameBuffer.FrameBufferBuilder(200, 200);
        builder.addColorTextureAttachment(Settings.settings.graphics.useSRGB ? 35907 : 34843, 6407, 5126);
        this.lumaBuffer = new GaiaSkyFrameBuffer((GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Texture>>)builder, 0);
        ((Texture)this.lumaBuffer.getColorBufferTexture()).setFilter(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear);
        this.lumaFilter.setImageSize(200.0f, 200.0f);
        this.lumaFilter.setTexelSize(0.005f, 0.005f);
        this.disposables.addAll((Object[])new Disposable[]{this.lumaFilter, this.levels, this.lumaBuffer});
    }

    public LumaFilter getLuma() {
        return this.lumaFilter;
    }

    public FrameBuffer getLumaBuffer() {
        return this.lumaBuffer;
    }

    public void setBrightness(float value) {
        this.levels.setBrightness(value);
    }

    public void setSaturation(float value) {
        this.levels.setSaturation(value);
    }

    public void setHue(float value) {
        this.levels.setHue(value);
    }

    public void setContrast(float value) {
        this.levels.setContrast(value);
    }

    public void setGamma(float value) {
        this.levels.setGamma(value);
    }

    public void setExposure(float value) {
        this.levels.setExposure(value);
    }

    public void enableToneMappingExposure() {
        this.levels.enableToneMappingExposure();
    }

    public void enableToneMappingAuto() {
        this.levels.enableToneMappingAuto();
    }

    public void enableToneMappingACES() {
        this.levels.enableToneMappingACES();
    }

    public void enableToneMappingUncharted() {
        this.levels.enableToneMappingUncharted();
    }

    public void enableToneMappingFilmic() {
        this.levels.enableToneMappingFilmic();
    }

    public void disableToneMapping() {
        this.levels.disableToneMapping();
    }

    @Override
    public void rebind() {
        this.levels.rebind();
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        this.restoreViewport(dest);
        if (this.levels.isToneMappingAuto()) {
            this.computeLumaValuesCPU(src);
        }
        ((LevelsFilter)((LevelsFilter)this.levels.setInput(src)).setOutput(dest)).render();
    }

    private void lowPassFilter(float baseLuma, float topLuma) {
        if (this.currLumaAvg < 0.0f) {
            this.currLumaAvg = this.lumaAvg;
            this.currLumaMax = this.lumaMax;
        } else {
            float dt = Gdx.graphics.getDeltaTime();
            float smoothingAvg = 0.2f;
            float smoothingMax = 0.2f;
            this.currLumaAvg += dt * (this.lumaAvg - this.currLumaAvg) / smoothingAvg;
            this.currLumaMax += dt * (this.lumaMax - this.currLumaMax) / smoothingMax;
        }
        GaiaSky.postRunnable(() -> {
            if (this.levels != null) {
                this.levels.setAvgMaxLuma(Math.max(this.currLumaAvg, baseLuma), FastMath.min((float)this.currLumaMax, (float)topLuma));
            }
            this.processRunning.set(false);
        });
    }

    private void computeLumaValuesCPU(FrameBuffer src) {
        if (!this.processRunning.get() && GaiaSky.instance.frames - this.lastFrame >= 4L) {
            this.processRunning.set(true);
            this.lumaFilter.enableProgramLuma();
            ((LumaFilter)((LumaFilter)this.lumaFilter.setInput(src)).setOutput(this.lumaBuffer)).render();
            ((Texture)this.lumaBuffer.getColorBufferTexture()).bind();
            GL30.glGetTexImage((int)((Texture)this.lumaBuffer.getColorBufferTexture()).glTarget, (int)0, (int)6407, (int)5126, (FloatBuffer)this.pixels);
            GaiaSky.instance.getExecutorService().execute(() -> {
                this.computeMaxAvg(this.pixels);
                if (!Double.isNaN(this.lumaAvg) && !Double.isNaN(this.lumaMax)) {
                    this.lowPassFilter(0.0f, 2.0f);
                } else {
                    this.processRunning.set(false);
                }
            });
            this.lastFrame = GaiaSky.instance.frames;
        }
    }

    private void computeMaxAvg(FloatBuffer buff) {
        buff.rewind();
        double avg = 0.0;
        double max = -1.7976931348623157E308;
        int i = 1;
        while (buff.hasRemaining()) {
            double v = buff.get();
            buff.get();
            buff.get();
            if (Double.isNaN(v)) continue;
            avg += (v - avg) / (double)(i + 1);
            max = FastMath.max((double)v, (double)max);
            ++i;
        }
        double frac = FastMath.min((double)1.0, (double)(8.0 * (1.0 - (max - avg) / max)));
        this.lumaMax = (float)(max * frac);
        this.lumaAvg = (float)avg;
        buff.clear();
    }

    private void computeLumaValuesMipMap(FrameBuffer src) {
        this.lumaFilter.enableProgramAvg();
        this.lumaAvg = this.renderLumaMipMap(src);
        this.lumaFilter.enableProgramMax();
        this.lumaMax = this.renderLumaMipMap(src);
        this.lowPassFilter(0.08f, 1.0f);
    }

    private float renderLumaMipMap(FrameBuffer src) {
        int mipLevel = 1;
        float lodLevel = 0.0f;
        int size = (int)FastMath.floor((float)100.0f);
        while ((float)size >= 1.0f) {
            this.lumaFilter.setImageSize(size, size);
            this.lumaFilter.setTexelSize(1.0f / (float)size, 1.0f / (float)size);
            this.lumaFilter.setLodLevel(lodLevel);
            ((LumaFilter)((LumaFilter)this.lumaFilter.setInput(src)).setOutput(this.lumaBuffer)).render();
            GL30.glCopyTexImage2D((int)3553, (int)mipLevel, (int)6408, (int)0, (int)0, (int)size, (int)size, (int)0);
            ++mipLevel;
            lodLevel += 1.0f;
            size = (int)FastMath.floor((float)((float)size / 2.0f));
        }
        this.lumaBuffer.begin();
        GL30.glReadPixels((int)0, (int)0, (int)1, (int)1, (int)6408, (int)5126, (FloatBuffer)this.pixels);
        this.lumaBuffer.end();
        this.pixels.rewind();
        return this.pixels.get();
    }
}

