/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.GlowFilter;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public final class LightGlow
extends PostProcessorEffect {
    private final GlowFilter glow;
    private Settings settings;
    private boolean blending = false;
    private int sFactor;
    private int dFactor;

    public LightGlow(int width, int height) {
        this.glow = new GlowFilter(width, height);
        this.disposables.add((Object)this.glow);
    }

    public void setBackBufferScale(float bbs) {
        this.glow.setBackbufferScale(bbs);
    }

    public void setLightPositions(int nLights, float[] vec) {
        this.glow.setLightPositions(nLights, vec);
    }

    public void setNLights(int nLights) {
        this.glow.setNLights(nLights);
    }

    public void setLightSolidAngles(float[] vec) {
        this.glow.setLightViewAngles(vec);
    }

    public void setLightColors(float[] vec) {
        this.glow.setLightColors(vec);
    }

    public void setNSamples(int nSamples) {
        this.glow.setNSamples(nSamples);
    }

    public void setTextureScale(float scl) {
        this.glow.setTextureScale(scl);
    }

    public void setSpiralScale(float scl) {
        this.glow.setSpiralScale(scl);
    }

    public void setOrientation(float o) {
        this.glow.setOrientation(o);
    }

    public void enableBlending(int sFactor, int dFactor) {
        this.blending = true;
        this.sFactor = sFactor;
        this.dFactor = dFactor;
    }

    public void disableBlending() {
        this.blending = false;
    }

    public Texture getLightGlowTexture() {
        return this.glow.getLightGlowTexture();
    }

    public void setLightGlowTexture(Texture tex) {
        this.glow.setLightGlowTexture(tex);
    }

    public Texture getOcclusionTexture() {
        return this.glow.getOcclusionTexture();
    }

    public void setOcclusionTexture(Texture tex) {
        this.glow.setOcclusionTexture(tex);
    }

    public boolean isBlendingEnabled() {
        return this.blending;
    }

    public int getBlendingSourceFactor() {
        return this.sFactor;
    }

    public int getBlendingDestFactor() {
        return this.dFactor;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        this.restoreViewport(dest);
        ((GlowFilter)((GlowFilter)this.glow.setInput(src)).setOutput(dest)).render();
    }

    public void setViewportSize(int width, int height) {
        this.glow.setViewportSize(width, height);
    }

    @Override
    public void rebind() {
        this.glow.rebind();
    }

    public static class Settings {
        public final String name;

        public Settings(String name) {
            this.name = name;
        }

        public Settings(Settings other) {
            this.name = other.name;
        }
    }
}

