/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.render.postprocess.PostProcessor;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.BiasFilter;
import gaiasky.render.postprocess.filters.BlurFilter;
import gaiasky.render.postprocess.filters.CombineFilter;
import gaiasky.render.postprocess.filters.LightScatteringFilter;
import gaiasky.render.postprocess.util.PingPongBuffer;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public final class LightScattering
extends PostProcessorEffect {
    private final PingPongBuffer pingPongBuffer;
    private final LightScatteringFilter scatteringFilter;
    private final BlurFilter blurFilter;
    private final BiasFilter biasFilter;
    private final CombineFilter combineFilter;
    private Settings settings;
    private boolean blending = false;
    private int sFactor;
    private int dFactor;

    public LightScattering(int fboWidth, int fboHeight) {
        this.pingPongBuffer = PostProcessor.newPingPongBuffer(fboWidth, fboHeight, Pixmap.Format.RGB888, false, false, false, false);
        this.scatteringFilter = new LightScatteringFilter(fboWidth, fboHeight);
        this.blurFilter = new BlurFilter(fboWidth, fboHeight);
        this.biasFilter = new BiasFilter();
        this.combineFilter = new CombineFilter();
        this.disposables.addAll((Object[])new Disposable[]{this.pingPongBuffer, this.scatteringFilter, this.blurFilter, this.biasFilter, this.combineFilter});
        this.setSettings(new Settings("default", 2, -0.9f, 1.0f, 1.0f, 0.7f, 1.0f));
    }

    public void setLightPositions(int nLights, float[] vec) {
        this.scatteringFilter.setLightPositions(nLights, vec);
    }

    public void setLightViewAngles(float[] vec) {
        this.scatteringFilter.setLightViewAngles(vec);
    }

    public void setBaseIntesity(float intensity) {
        this.combineFilter.setSource1Intensity(intensity);
    }

    public void setScatteringIntesity(float intensity) {
        this.combineFilter.setSource2Intensity(intensity);
    }

    public void enableBlending(int sfactor, int dfactor) {
        this.blending = true;
        this.sFactor = sfactor;
        this.dFactor = dfactor;
    }

    public void disableBlending() {
        this.blending = false;
    }

    public void setDecay(float decay) {
        this.scatteringFilter.setDecay(decay);
    }

    public void setDensity(float density) {
        this.scatteringFilter.setDensity(density);
    }

    public void setWeight(float weight) {
        this.scatteringFilter.setWeight(weight);
    }

    public void setNumSamples(int numSamples) {
        this.scatteringFilter.setNumSamples(numSamples);
    }

    public float getBias() {
        return this.biasFilter.getBias();
    }

    public void setBias(float b) {
        this.biasFilter.setBias(b);
    }

    public float getBaseIntensity() {
        return this.combineFilter.getSource1Intensity();
    }

    public float getBaseSaturation() {
        return this.combineFilter.getSource1Saturation();
    }

    public void setBaseSaturation(float saturation) {
        this.combineFilter.setSource1Saturation(saturation);
    }

    public float getScatteringIntensity() {
        return this.combineFilter.getSource2Intensity();
    }

    public float getScatteringSaturation() {
        return this.combineFilter.getSource2Saturation();
    }

    public void setScatteringSaturation(float saturation) {
        this.combineFilter.setSource2Saturation(saturation);
    }

    public boolean isBlendingEnabled() {
        return this.blending;
    }

    public int getBlendingSourceFactor() {
        return this.sFactor;
    }

    public int getBlendingDestFactor() {
        return this.dFactor;
    }

    public BlurFilter.BlurType getBlurType() {
        return this.blurFilter.getType();
    }

    public void setBlurType(BlurFilter.BlurType type) {
        this.blurFilter.setType(type);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.setBias(settings.bias);
        this.setBaseIntesity(settings.baseIntensity);
        this.setBaseSaturation(settings.baseSaturation);
        this.setScatteringIntesity(settings.scatteringIntensity);
        this.setScatteringSaturation(settings.scatteringSaturation);
        this.setBlurPasses(settings.blurPasses);
        this.setBlurAmount(settings.blurAmount);
        this.setBlurType(settings.blurType);
    }

    public int getBlurPasses() {
        return this.blurFilter.getPasses();
    }

    public void setBlurPasses(int passes) {
        this.blurFilter.setPasses(passes);
    }

    public float getBlurAmount() {
        return this.blurFilter.getAmount();
    }

    public void setBlurAmount(float amount) {
        this.blurFilter.setAmount(amount);
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        Texture texsrc = (Texture)src.getColorBufferTexture();
        boolean blendingWasEnabled = PostProcessor.isStateEnabled(3042);
        Gdx.gl.glDisable(3042);
        this.pingPongBuffer.begin();
        ((BiasFilter)((BiasFilter)this.biasFilter.setInput(texsrc)).setOutput(this.pingPongBuffer.getSourceBuffer())).render();
        ((LightScatteringFilter)((LightScatteringFilter)this.scatteringFilter.setInput(this.pingPongBuffer.getSourceBuffer())).setOutput(this.pingPongBuffer.getResultBuffer())).render();
        this.pingPongBuffer.set(this.pingPongBuffer.getResultBuffer(), this.pingPongBuffer.getSourceBuffer());
        this.blurFilter.render(this.pingPongBuffer);
        this.pingPongBuffer.end();
        if (this.blending || blendingWasEnabled) {
            Gdx.gl.glEnable(3042);
        }
        if (this.blending) {
            Gdx.gl.glBlendFunc(this.sFactor, this.dFactor);
        }
        this.restoreViewport(dest);
        ((CombineFilter)this.combineFilter.setOutput(dest)).setInput(texsrc, this.pingPongBuffer.getResultTexture()).render();
    }

    @Override
    public void rebind() {
        this.blurFilter.rebind();
        this.biasFilter.rebind();
        this.combineFilter.rebind();
        this.pingPongBuffer.rebind();
    }

    public static class Settings {
        public final String name;
        public final BlurFilter.BlurType blurType;
        public final int blurPasses;
        public final float blurAmount;
        public final float bias;
        public final float scatteringIntensity;
        public final float scatteringSaturation;
        public final float baseIntensity;
        public final float baseSaturation;

        public Settings(String name, BlurFilter.BlurType blurType, int blurPasses, float blurAmount, float bias, float baseIntensity, float baseSaturation, float scatteringIntensity, float scatteringSaturation) {
            this.name = name;
            this.blurType = blurType;
            this.blurPasses = blurPasses;
            this.blurAmount = blurAmount;
            this.bias = bias;
            this.baseIntensity = baseIntensity;
            this.baseSaturation = baseSaturation;
            this.scatteringIntensity = scatteringIntensity;
            this.scatteringSaturation = scatteringSaturation;
        }

        public Settings(String name, int blurPasses, float bias, float baseIntensity, float baseSaturation, float scatteringIntensity, float scatteringSaturation) {
            this(name, BlurFilter.BlurType.Gaussian5x5b, blurPasses, 0.0f, bias, baseIntensity, baseSaturation, scatteringIntensity, scatteringSaturation);
        }

        public Settings(Settings other) {
            this.name = other.name;
            this.blurType = other.blurType;
            this.blurPasses = other.blurPasses;
            this.blurAmount = other.blurAmount;
            this.bias = other.bias;
            this.baseIntensity = other.baseIntensity;
            this.baseSaturation = other.baseSaturation;
            this.scatteringIntensity = other.scatteringIntensity;
            this.scatteringSaturation = other.scatteringSaturation;
        }
    }
}

