/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.NoiseFilter;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public final class Noise
extends PostProcessorEffect {
    private final NoiseFilter filter;

    public Noise(int viewportWidth, int viewportHeight, int targets) {
        this.filter = new NoiseFilter(viewportWidth, viewportHeight, targets);
        this.disposables.add((Object)this.filter);
    }

    public void setViewportSize(int width, int height) {
        this.filter.setViewportSize(width, height);
    }

    public void setRange(float a, float b) {
        this.filter.setRange(a, b);
    }

    public void setColor(float[] color) {
        this.filter.setColor(color[0], color[1], color[2], color[3]);
    }

    public void setScale(double[] scale) {
        this.filter.setScale((float)scale[0], (float)scale[1], (float)scale[2]);
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.filter.setScale(scaleX, scaleY, scaleZ);
    }

    public void setScale(float scale) {
        this.filter.setScale(scale);
    }

    public void setSeed(float seed) {
        this.filter.setSeed(seed);
    }

    public void setAmplitude(double amplitude) {
        this.filter.setAmplitude((float)amplitude);
    }

    public void setAmplitude(float amplitude) {
        this.filter.setAmplitude(amplitude);
    }

    public void setPersistence(double persistence) {
        this.filter.setPersistence((float)persistence);
    }

    public void setPersistence(float persistence) {
        this.filter.setPersistence(persistence);
    }

    public void setFrequency(double frequency) {
        this.filter.setFrequency((float)frequency);
    }

    public void setFrequency(float frequency) {
        this.filter.setFrequency(frequency);
    }

    public void setLacunarity(double lacunarity) {
        this.filter.setLacunarity((float)lacunarity);
    }

    public void setLacunarity(float lacunarity) {
        this.filter.setLacunarity(lacunarity);
    }

    public void setPower(double power) {
        this.filter.setPower((float)power);
    }

    public void setPower(float power) {
        this.filter.setPower(power);
    }

    public void setOctaves(int octaves) {
        this.filter.setOctaves(octaves);
    }

    public void setTurbulence(boolean turbulence) {
        this.filter.setTurbulence(turbulence);
    }

    public void setRidge(boolean ridge) {
        this.filter.setRidge(ridge);
    }

    public void setNumTerraces(int numTerraces) {
        this.filter.setNumTerraces(numTerraces);
    }

    public void setTerraceExp(float terraceExp) {
        this.filter.setTerraceExp(terraceExp);
    }

    public void setChannels(int channels) {
        this.filter.setChannels(channels);
    }

    public void setType(NoiseFilter.NoiseType type) {
        this.filter.setType(type);
    }

    @Override
    public void rebind() {
        this.filter.rebind();
    }

    public void render(FrameBuffer src, FrameBuffer dest) {
        this.restoreViewport(dest);
        ((NoiseFilter)((NoiseFilter)this.filter.setInput(src)).setOutput(dest)).render();
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        this.restoreViewport(dest);
        ((NoiseFilter)((NoiseFilter)this.filter.setInput(src)).setOutput(dest)).render();
    }
}

