/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.render.postprocess.PostProcessor;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.BiasFilter;
import gaiasky.render.postprocess.filters.BlurFilter;
import gaiasky.render.postprocess.filters.CombineFilter;
import gaiasky.render.postprocess.filters.LensDirtFilter;
import gaiasky.render.postprocess.filters.PseudoLensFlareFilter;
import gaiasky.render.postprocess.util.PingPongBuffer;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public final class PseudoLensFlare
extends PostProcessorEffect {
    private final PingPongBuffer pingPongBuffer;
    private final PseudoLensFlareFilter flare;
    private final LensDirtFilter dirt;
    private final BlurFilter blurFilter;
    private final BiasFilter biasFilter;
    private final CombineFilter combineFilter;
    private Settings settings;
    private boolean blending = false;
    private int sFactor;
    private int dFactor;

    public PseudoLensFlare(int fboWidth, int fboHeight) {
        this.pingPongBuffer = PostProcessor.newPingPongBuffer(fboWidth, fboHeight, Pixmap.Format.RGB888, false, false, false, false);
        this.flare = new PseudoLensFlareFilter(fboWidth, fboHeight);
        this.dirt = new LensDirtFilter();
        this.blurFilter = new BlurFilter(fboWidth, fboHeight);
        this.biasFilter = new BiasFilter();
        this.combineFilter = new CombineFilter();
        this.disposables.addAll((Object[])new Disposable[]{this.pingPongBuffer, this.flare, this.dirt, this.blurFilter, this.biasFilter, this.combineFilter});
        this.setSettings(new Settings("default", 2, -0.9f, 1.0f, 1.0f, 0.7f, 1.0f, 8, 0.5f));
    }

    public void setBaseIntensity(float intensity) {
        this.combineFilter.setSource1Intensity(intensity);
    }

    public void setFlareIntensity(float intensity) {
        this.combineFilter.setSource2Intensity(intensity);
    }

    public void setHaloWidth(float haloWidth) {
        this.flare.setHaloWidth(haloWidth);
    }

    public void setLensColorTexture(Texture tex) {
        this.flare.setLensColorTexture(tex);
    }

    public void setLensDirtTexture(Texture tex) {
        this.dirt.setLensDirtTexture(tex);
    }

    public void setLensStarburstTexture(Texture tex) {
        this.dirt.setLensStarburstTexture(tex);
    }

    public void setStarburstOffset(float offset) {
        this.dirt.setStarburstOffset(offset);
    }

    public void enableBlending(int sfactor, int dfactor) {
        this.blending = true;
        this.sFactor = sfactor;
        this.dFactor = dfactor;
    }

    public void disableBlending() {
        this.blending = false;
    }

    public float getBias() {
        return this.biasFilter.getBias();
    }

    public void setBias(float b) {
        this.biasFilter.setBias(b);
    }

    public float getBaseIntensity() {
        return this.combineFilter.getSource1Intensity();
    }

    public float getBaseSaturation() {
        return this.combineFilter.getSource1Saturation();
    }

    public void setBaseSaturation(float saturation) {
        this.combineFilter.setSource1Saturation(saturation);
    }

    public float getFlareIntensity() {
        return this.combineFilter.getSource2Intensity();
    }

    public float getFlareSaturation() {
        return this.combineFilter.getSource2Saturation();
    }

    public void setFlareSaturation(float saturation) {
        this.combineFilter.setSource2Saturation(saturation);
    }

    public int getGhosts() {
        return this.flare.getGhosts();
    }

    public void setGhosts(int ghosts) {
        this.flare.setGhosts(ghosts);
    }

    public boolean isBlendingEnabled() {
        return this.blending;
    }

    public int getBlendingSourceFactor() {
        return this.sFactor;
    }

    public int getBlendingDestFactor() {
        return this.dFactor;
    }

    public BlurFilter.BlurType getBlurType() {
        return this.blurFilter.getType();
    }

    public void setBlurType(BlurFilter.BlurType type) {
        this.blurFilter.setType(type);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.setBias(settings.flareBias);
        this.setBaseIntensity(settings.baseIntensity);
        this.setBaseSaturation(settings.baseSaturation);
        this.setFlareIntensity(settings.flareIntensity);
        this.setFlareSaturation(settings.flareSaturation);
        this.setBlurPasses(settings.blurPasses);
        this.setBlurAmount(settings.blurAmount);
        this.setBlurType(settings.blurType);
        this.setGhosts(settings.ghosts);
    }

    public int getBlurPasses() {
        return this.blurFilter.getPasses();
    }

    public void setBlurPasses(int passes) {
        this.blurFilter.setPasses(passes);
    }

    public float getBlurAmount() {
        return this.blurFilter.getAmount();
    }

    public void setBlurAmount(float amount) {
        this.blurFilter.setAmount(amount);
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        boolean blendingWasEnabled = PostProcessor.isStateEnabled(3042);
        Gdx.gl.glDisable(3042);
        this.pingPongBuffer.begin();
        ((BiasFilter)((BiasFilter)this.biasFilter.setInput((Texture)src.getColorBufferTexture())).setOutput(this.pingPongBuffer.getSourceBuffer())).render();
        ((PseudoLensFlareFilter)((PseudoLensFlareFilter)this.flare.setInput(this.pingPongBuffer.getSourceBuffer())).setOutput(this.pingPongBuffer.getResultBuffer())).render();
        this.pingPongBuffer.set(this.pingPongBuffer.getResultBuffer(), this.pingPongBuffer.getSourceBuffer());
        this.blurFilter.render(this.pingPongBuffer);
        ((LensDirtFilter)((LensDirtFilter)this.dirt.setInput(this.pingPongBuffer.getSourceBuffer())).setOutput(this.pingPongBuffer.getResultBuffer())).render();
        this.pingPongBuffer.end();
        if (this.blending || blendingWasEnabled) {
            Gdx.gl.glEnable(3042);
        }
        if (this.blending) {
            Gdx.gl.glBlendFunc(this.sFactor, this.dFactor);
        }
        this.restoreViewport(dest);
        ((CombineFilter)this.combineFilter.setOutput(dest)).setInput((Texture)src.getColorBufferTexture(), this.pingPongBuffer.getResultTexture()).render();
    }

    @Override
    public void rebind() {
        this.blurFilter.rebind();
        this.biasFilter.rebind();
        this.combineFilter.rebind();
        this.pingPongBuffer.rebind();
    }

    public static class Settings {
        public final String name;
        public final BlurFilter.BlurType blurType;
        public final int blurPasses;
        public final float blurAmount;
        public final float flareBias;
        public final float flareIntensity;
        public final float flareSaturation;
        public final float baseIntensity;
        public final float baseSaturation;
        public final int ghosts;
        public final float haloWidth;

        public Settings(String name, BlurFilter.BlurType blurType, int blurPasses, float blurAmount, float flareBias, float baseIntensity, float baseSaturation, float flareIntensity, float flareSaturation, int ghosts, float haloWidth) {
            this.name = name;
            this.blurType = blurType;
            this.blurPasses = blurPasses;
            this.blurAmount = blurAmount;
            this.flareBias = flareBias;
            this.baseIntensity = baseIntensity;
            this.baseSaturation = baseSaturation;
            this.flareIntensity = flareIntensity;
            this.flareSaturation = flareSaturation;
            this.ghosts = ghosts;
            this.haloWidth = haloWidth;
        }

        public Settings(String name, int blurPasses, float flareBias, float baseIntensity, float baseSaturation, float flareIntensity, float flareSaturation, int ghosts, float haloWidth) {
            this(name, BlurFilter.BlurType.Gaussian5x5b, blurPasses, 0.0f, flareBias, baseIntensity, baseSaturation, flareIntensity, flareSaturation, ghosts, haloWidth);
        }

        public Settings(Settings other) {
            this.name = other.name;
            this.blurType = other.blurType;
            this.blurPasses = other.blurPasses;
            this.blurAmount = other.blurAmount;
            this.flareBias = other.flareBias;
            this.baseIntensity = other.baseIntensity;
            this.baseSaturation = other.baseSaturation;
            this.flareIntensity = other.flareIntensity;
            this.flareSaturation = other.flareSaturation;
            this.ghosts = other.ghosts;
            this.haloWidth = other.haloWidth;
        }
    }
}

