/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.RaymarchingFilter;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public final class RaymarchObject
extends PostProcessorEffect {
    private final RaymarchingFilter filter;

    public RaymarchObject(String fragmentShader, float viewportWidth, float viewportHeight) {
        this(fragmentShader, (int)viewportWidth, (int)viewportHeight);
    }

    public RaymarchObject(String fragmentShader, int viewportWidth, int viewportHeight) {
        this.filter = new RaymarchingFilter(fragmentShader, viewportWidth, viewportHeight);
        this.disposables.add((Object)this.filter);
    }

    public void setViewportSize(int width, int height) {
        this.filter.setViewportSize(width, height);
    }

    public void setFrustumCorners(Matrix4 frustumCorners) {
        this.filter.setFrustumCorners(frustumCorners);
    }

    public void setView(Matrix4 view) {
        this.filter.setView(view);
    }

    public void setCombined(Matrix4 viewProjection) {
        this.filter.setCombined(viewProjection);
    }

    public void setPos(Vector3 pos) {
        this.filter.setPos(pos);
    }

    public void setTime(float seconds) {
        this.filter.setTime(seconds);
    }

    public void setSize(float size) {
        this.filter.setSize(size);
    }

    public void setZfarK(float zfar, float k) {
        this.filter.setZfarK(zfar, k);
    }

    public void setAdditionalTexture(Texture tex) {
        this.filter.setAdditionalTexture(tex);
    }

    public void setAdditional(float[] additional) {
        this.filter.setAdditional(additional);
    }

    public void setAdditional(float a, float b, float c, float d) {
        this.filter.setAdditional(a, b, c, d);
    }

    public void setAdditional(int index, float value) {
        this.filter.setAdditional(index, value);
    }

    @Override
    public void updateShaders() {
        super.updateShaders();
        this.filter.updateProgram();
    }

    @Override
    public void rebind() {
        this.filter.rebind();
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        this.restoreViewport(dest);
        this.filter.setDepthTexture(main.getDepthBufferTexture());
        ((RaymarchingFilter)((RaymarchingFilter)this.filter.setInput(src)).setOutput(dest)).render();
    }
}

