/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.SSRFilter;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public class SSR
extends PostProcessorEffect {
    private final SSRFilter filter = new SSRFilter();

    public SSR() {
        this.disposables.add((Object)this.filter);
    }

    public void setFrustumCorners(Matrix4 frustumCorners) {
        this.filter.setFrustumCorners(frustumCorners);
    }

    public void setCombined(Matrix4 combined) {
        this.filter.setCombined(combined);
    }

    public void setProjection(Matrix4 proj) {
        this.filter.setProjection(proj);
    }

    public void setView(Matrix4 view) {
        this.filter.setView(view);
    }

    public void setZfarK(float zfar, float k) {
        this.filter.setZfarK(zfar, k);
    }

    public void setTexture1(Texture tex) {
        this.filter.setTexture1(tex);
    }

    public void setTexture2(Texture tex) {
        this.filter.setTexture2(tex);
    }

    public void setTexture3(Texture tex) {
        this.filter.setTexture3(tex);
    }

    @Override
    public void rebind() {
        if (this.filter != null) {
            this.filter.rebind();
        }
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        this.restoreViewport(dest);
        this.filter.setDepthTexture(main.getDepthBufferTexture());
        this.filter.setNormalTexture(main.getNormalBufferTexture());
        this.filter.setReflectionTexture(main.getReflectionMaskBufferTexture());
        ((SSRFilter)((SSRFilter)this.filter.setInput(src)).setOutput(dest)).render();
    }
}

