/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.VignettingFilter;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public final class Vignette
extends PostProcessorEffect {
    private final VignettingFilter vignettingFilter;
    private final boolean controlSaturation;
    private final float oneOnW;
    private final float oneOnH;

    public Vignette(int viewportWidth, int viewportHeight, boolean controlSaturation) {
        this.controlSaturation = controlSaturation;
        this.oneOnW = 1.0f / (float)viewportWidth;
        this.oneOnH = 1.0f / (float)viewportHeight;
        this.vignettingFilter = new VignettingFilter(controlSaturation);
        this.disposables.add((Object)this.vignettingFilter);
    }

    public boolean doesSaturationControl() {
        return this.controlSaturation;
    }

    public void setCoords(float x, float y) {
        this.vignettingFilter.setCoords(x, y);
    }

    public void setX(float x) {
        this.vignettingFilter.setX(x);
    }

    public void setY(float y) {
        this.vignettingFilter.setY(y);
    }

    public void setLutTexture(Texture texture) {
        this.vignettingFilter.setLut(texture);
    }

    public void setLutIndexVal(int index, int value) {
        this.vignettingFilter.setLutIndexVal(index, value);
    }

    public void setLutIndexOffset(float value) {
        this.vignettingFilter.setLutIndexOffset(value);
    }

    public void setCenter(float x, float y) {
        this.vignettingFilter.setCenter(x * this.oneOnW, 1.0f - y * this.oneOnH);
    }

    public float getIntensity() {
        return this.vignettingFilter.getIntensity();
    }

    public void setIntensity(float intensity) {
        this.vignettingFilter.setIntensity(intensity);
    }

    public float getLutIntensity() {
        return this.vignettingFilter.getLutIntensity();
    }

    public void setLutIntensity(float value) {
        this.vignettingFilter.setLutIntensity(value);
    }

    public int getLutIndexVal(int index) {
        return this.vignettingFilter.getLutIndexVal(index);
    }

    public Texture getLut() {
        return this.vignettingFilter.getLut();
    }

    public float getCenterX() {
        return this.vignettingFilter.getCenterX();
    }

    public float getCenterY() {
        return this.vignettingFilter.getCenterY();
    }

    public float getCoordsX() {
        return this.vignettingFilter.getX();
    }

    public float getCoordsY() {
        return this.vignettingFilter.getY();
    }

    public float getSaturation() {
        return this.vignettingFilter.getSaturation();
    }

    public void setSaturation(float saturation) {
        this.vignettingFilter.setSaturation(saturation);
    }

    public float getSaturationMul() {
        return this.vignettingFilter.getSaturationMul();
    }

    public void setSaturationMul(float saturationMul) {
        this.vignettingFilter.setSaturationMul(saturationMul);
    }

    public boolean isGradientMappingEnabled() {
        return this.vignettingFilter.isGradientMappingEnabled();
    }

    @Override
    public void rebind() {
        this.vignettingFilter.rebind();
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        this.restoreViewport(dest);
        ((VignettingFilter)((VignettingFilter)this.vignettingFilter.setInput(src)).setOutput(dest)).render();
    }
}

