/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.effects;

import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.PostProcessorEffect;
import gaiasky.render.postprocess.filters.RadialBlurFilter;
import gaiasky.render.postprocess.filters.ZoomFilter;
import gaiasky.render.util.GaiaSkyFrameBuffer;

public final class Zoomer
extends PostProcessorEffect {
    private final boolean doRadial;
    private final RadialBlurFilter radialBlurFilter;
    private final ZoomFilter zoomFilter;
    private final float oneOnW;
    private final float oneOnH;
    private float userOriginX;
    private float userOriginY;

    public Zoomer(int viewportWidth, int viewportHeight, RadialBlurFilter.Quality quality) {
        RadialBlurFilter radialBlurFilter = this.radialBlurFilter = quality != null ? new RadialBlurFilter(quality) : null;
        if (this.radialBlurFilter != null) {
            this.doRadial = true;
            this.zoomFilter = null;
            this.disposables.add((Object)this.radialBlurFilter);
        } else {
            this.doRadial = false;
            this.zoomFilter = new ZoomFilter();
            this.disposables.add((Object)this.zoomFilter);
        }
        this.oneOnW = 1.0f / (float)viewportWidth;
        this.oneOnH = 1.0f / (float)viewportHeight;
    }

    public Zoomer(int viewportWidth, int viewportHeight) {
        this(viewportWidth, viewportHeight, null);
    }

    public void setOrigin(Vector2 o) {
        this.setOrigin(o.x, o.y);
    }

    public void setOrigin(float x, float y) {
        this.userOriginX = x;
        this.userOriginY = y;
        if (this.doRadial) {
            this.radialBlurFilter.setOrigin(x * this.oneOnW, 1.0f - y * this.oneOnH);
        } else {
            this.zoomFilter.setOrigin(x * this.oneOnW, 1.0f - y * this.oneOnH);
        }
    }

    public float getZoom() {
        if (this.doRadial) {
            return 1.0f / this.radialBlurFilter.getZoom();
        }
        return 1.0f / this.zoomFilter.getZoom();
    }

    public void setZoom(float zoom) {
        if (this.doRadial) {
            this.radialBlurFilter.setZoom(1.0f / zoom);
        } else {
            this.zoomFilter.setZoom(1.0f / zoom);
        }
    }

    public float getBlurStrength() {
        if (this.doRadial) {
            return this.radialBlurFilter.getStrength();
        }
        return -1.0f;
    }

    public void setBlurStrength(float strength) {
        if (this.doRadial) {
            this.radialBlurFilter.setStrength(strength);
        }
    }

    public float getOriginX() {
        return this.userOriginX;
    }

    public float getOriginY() {
        return this.userOriginY;
    }

    @Override
    public void rebind() {
        this.radialBlurFilter.rebind();
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dest, GaiaSkyFrameBuffer main) {
        this.restoreViewport(dest);
        if (this.doRadial) {
            ((RadialBlurFilter)((RadialBlurFilter)this.radialBlurFilter.setInput(src)).setOutput(dest)).render();
        } else {
            ((ZoomFilter)((ZoomFilter)this.zoomFilter.setInput(src)).setOutput(dest)).render();
        }
    }
}

