/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public class AccumulationBlurFilter
extends Filter<AccumulationBlurFilter> {
    private final Vector2 resolution = new Vector2();
    private float blurOpacity = 0.5f;
    private float blurRadius = 0.5f;
    private Texture lastFrameTex;

    public AccumulationBlurFilter() {
        super(ShaderLoader.fromFile("screenspace", "motionblur"));
        this.rebind();
    }

    public void setBlurOpacity(float blurOpacity) {
        this.blurOpacity = blurOpacity;
        this.setParam((Filter.Parameter)Param.BlurOpacity, this.blurOpacity);
    }

    public void setBlurRadius(float blurRadius) {
        this.blurRadius = blurRadius;
        this.setParam((Filter.Parameter)Param.BlurRadius, this.blurRadius);
    }

    public void setResolution(int w, int h) {
        this.resolution.set((float)w, (float)h);
        this.setParam((Filter.Parameter)Param.Resolution, this.resolution);
    }

    public void setLastFrameTexture(Texture tex) {
        this.lastFrameTex = tex;
        if (this.lastFrameTex != null) {
            this.setParam((Filter.Parameter)Param.LastFrame, 1);
        }
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        if (this.lastFrameTex != null) {
            this.setParams((Filter.Parameter)Param.LastFrame, 1);
        }
        this.setParams((Filter.Parameter)Param.BlurOpacity, this.blurOpacity);
        this.setParams((Filter.Parameter)Param.BlurRadius, this.blurRadius);
        this.setParams((Filter.Parameter)Param.Resolution, this.resolution);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
        if (this.lastFrameTex != null) {
            this.lastFrameTex.bind(1);
        }
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        LastFrame("u_texture1", 0),
        BlurOpacity("u_blurOpacity", 0),
        BlurRadius("u_blurRadius", 0),
        Resolution("u_resolution", 2);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

