/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class AnaglyphFilter
extends Filter<AnaglyphFilter> {
    private Texture textureLeft;
    private Texture textureRight;
    private int anaglyphMode;

    public AnaglyphFilter() {
        super(ShaderLoader.fromFile("screenspace", "anaglyphic"));
        this.rebind();
    }

    @Override
    protected void onBeforeRender() {
        if (this.textureLeft != null) {
            this.textureLeft.bind(0);
        }
        if (this.textureRight != null) {
            this.textureRight.bind(1);
        }
    }

    public void setTextureLeft(Texture tex) {
        this.textureLeft = tex;
        this.setParam((Filter.Parameter)Param.TextureLeft, 0);
    }

    public void setTextureRight(Texture tex) {
        this.textureRight = tex;
        this.setParam((Filter.Parameter)Param.TextureRight, 1);
    }

    public void setAnaglyphMode(int anaglyphMode) {
        this.anaglyphMode = anaglyphMode;
        this.setParam((Filter.Parameter)Param.AnaglyphMode, anaglyphMode);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.TextureLeft, 0);
        this.setParams((Filter.Parameter)Param.TextureRight, 1);
        this.setParams((Filter.Parameter)Param.AnaglyphMode, this.anaglyphMode);
        this.endParams();
    }

    public static enum Param implements Filter.Parameter
    {
        AnaglyphMode("u_anaglyphMode", 0),
        TextureLeft("u_texture0", 0),
        TextureRight("u_texture1", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String m, int elementSize) {
            this.mnemonic = m;
            this.elementSize = elementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

