/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class CameraMotionBlurFilter
extends Filter<CameraMotionBlurFilter> {
    private final Vector2 viewport = new Vector2();
    private final Vector3 dCam = new Vector3();
    private final Vector2 zFarK = new Vector2();
    private final Matrix4 projViewInverse = new Matrix4();
    private final Matrix4 prevProjView = new Matrix4();
    private Texture depthTexture = null;
    private float blurScale;
    private int samples;

    public CameraMotionBlurFilter() {
        super(ShaderLoader.fromFile("screenspace", "camerablur"));
        this.rebind();
    }

    public void setDepthTexture(Texture texture) {
        this.depthTexture = texture;
    }

    public void setProjViewInverse(Matrix4 m) {
        this.projViewInverse.set(m);
        this.setParam((Filter.Parameter)Param.ProjViewInverse, m);
    }

    public void setProjView(Matrix4 m) {
        this.projViewInverse.set(m).inv();
        this.setParam((Filter.Parameter)Param.ProjViewInverse, this.projViewInverse);
    }

    public void setPrevProjView(Matrix4 m) {
        this.prevProjView.set(m);
        this.setParam((Filter.Parameter)Param.PrevProjView, this.prevProjView);
    }

    public void setBlurMaxSamples(int samples) {
        this.samples = samples;
        this.setParam((Filter.Parameter)Param.BlurMaxSamples, samples);
    }

    public void setBlurScale(float blurScale) {
        this.blurScale = blurScale;
        this.setParam((Filter.Parameter)Param.BlurScale, blurScale);
    }

    public void setDCam(Vector3 d) {
        this.dCam.set(d);
        this.setParam((Filter.Parameter)Param.DCam, this.dCam);
    }

    public void setZFarK(float zfar, float k) {
        this.zFarK.set(zfar, k);
        this.setParam((Filter.Parameter)Param.ZFarK, this.zFarK);
    }

    public void setViewport(float width, float height) {
        this.viewport.set(width, height);
        this.setParam((Filter.Parameter)Param.Viewport, this.viewport);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.InputScene, 0);
        this.setParams((Filter.Parameter)Param.DepthMap, 2);
        this.setParams((Filter.Parameter)Param.PrevProjView, this.prevProjView);
        this.setParams((Filter.Parameter)Param.ProjViewInverse, this.projViewInverse);
        this.setParams((Filter.Parameter)Param.Viewport, this.viewport);
        this.setParams((Filter.Parameter)Param.DCam, this.dCam);
        this.setParams((Filter.Parameter)Param.ZFarK, this.zFarK);
        this.setParams((Filter.Parameter)Param.BlurScale, this.blurScale);
        this.setParams((Filter.Parameter)Param.BlurMaxSamples, this.samples);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.rebind();
        this.inputTexture.bind(0);
        this.depthTexture.bind(2);
    }

    public static enum Param implements Filter.Parameter
    {
        InputScene("u_texture0", 0),
        DepthMap("u_texture1", 0),
        PrevProjView("u_prevProjView", 16),
        ProjViewInverse("u_projViewInverse", 16),
        DCam("u_dCam", 3),
        ZFarK("u_zFarK", 2),
        BlurMaxSamples("u_blurSamplesMax", 0),
        BlurScale("u_blurScale", 0),
        Viewport("u_viewport", 2);

        private final String mnemonic;
        private final int elementSize;

        private Param(String m, int elementSize) {
            this.mnemonic = m;
            this.elementSize = elementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

