/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.math.MathUtils;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class ChromaticAberrationFilter
extends Filter<ChromaticAberrationFilter> {
    private float aberrationAmount;

    public ChromaticAberrationFilter(float amount) {
        super(ShaderLoader.fromFile("screenspace", "chromaticaberration"));
        this.aberrationAmount = amount;
        this.rebind();
    }

    public void setAberrationAmount(float amount) {
        this.aberrationAmount = MathUtils.clamp((float)amount, (float)0.0f, (float)0.05f);
        this.setParam((Filter.Parameter)Param.AberrationAmount, this.aberrationAmount);
    }

    public float getAberrationAmount() {
        return this.aberrationAmount;
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.AberrationAmount, this.aberrationAmount);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        AberrationAmount("u_aberrationAmount", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

