/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class CombineFilter
extends Filter<CombineFilter> {
    private float s1i = 1.0f;
    private float s1s = 1.0f;
    private float s2i = 1.0f;
    private float s2s = 1.0f;
    private Texture inputTexture2 = null;

    public CombineFilter() {
        super(ShaderLoader.fromFile("screenspace", "combine"));
        this.rebind();
    }

    public CombineFilter setInput(FrameBuffer buffer1, FrameBuffer buffer2) {
        this.inputTexture = (Texture)buffer1.getColorBufferTexture();
        this.inputTexture2 = (Texture)buffer2.getColorBufferTexture();
        return this;
    }

    public CombineFilter setInput(Texture texture1, Texture texture2) {
        this.inputTexture = texture1;
        this.inputTexture2 = texture2;
        return this;
    }

    public float getSource1Intensity() {
        return this.s1i;
    }

    public void setSource1Intensity(float intensity) {
        this.s1i = intensity;
        this.setParam((Filter.Parameter)Param.Source1Intensity, intensity);
    }

    public float getSource2Intensity() {
        return this.s2i;
    }

    public void setSource2Intensity(float intensity) {
        this.s2i = intensity;
        this.setParam((Filter.Parameter)Param.Source2Intensity, intensity);
    }

    public float getSource1Saturation() {
        return this.s1s;
    }

    public void setSource1Saturation(float saturation) {
        this.s1s = saturation;
        this.setParam((Filter.Parameter)Param.Source1Saturation, saturation);
    }

    public float getSource2Saturation() {
        return this.s2s;
    }

    public void setSource2Saturation(float saturation) {
        this.s2s = saturation;
        this.setParam((Filter.Parameter)Param.Source2Saturation, saturation);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture0, 0);
        this.setParams((Filter.Parameter)Param.Texture1, 1);
        this.setParams((Filter.Parameter)Param.Source1Intensity, this.s1i);
        this.setParams((Filter.Parameter)Param.Source2Intensity, this.s2i);
        this.setParams((Filter.Parameter)Param.Source1Saturation, this.s1s);
        this.setParams((Filter.Parameter)Param.Source2Saturation, this.s2s);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
        this.inputTexture2.bind(1);
    }

    public static enum Param implements Filter.Parameter
    {
        Texture0("u_texture0", 0),
        Texture1("u_texture1", 0),
        Source1Intensity("u_src1Intensity", 0),
        Source1Saturation("u_src1Saturation", 0),
        Source2Intensity("u_src2Intensity", 0),
        Source2Saturation("u_src2Saturation", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String m, int elementSize) {
            this.mnemonic = m;
            this.elementSize = elementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

