/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import gaiasky.render.postprocess.filters.Convolve1DFilter;
import gaiasky.render.postprocess.filters.MultipassFilter;
import gaiasky.render.postprocess.util.PingPongBuffer;

public final class Convolve2DFilter
extends MultipassFilter {
    public final int radius;
    public final int length;
    public final float[] weights;
    public final float[] offsetsHor;
    public final float[] offsetsVert;
    private final Convolve1DFilter hor;
    private final Convolve1DFilter vert;

    public Convolve2DFilter(int radius) {
        this.radius = radius;
        this.length = radius * 2 + 1;
        this.hor = new Convolve1DFilter(this.length);
        this.vert = new Convolve1DFilter(this.length, this.hor.weights);
        this.weights = this.hor.weights;
        this.offsetsHor = this.hor.offsets;
        this.offsetsVert = this.vert.offsets;
    }

    public void dispose() {
        this.hor.dispose();
        this.vert.dispose();
    }

    public void upload() {
        this.rebind();
    }

    @Override
    public void rebind() {
        this.hor.rebind();
        this.vert.rebind();
    }

    @Override
    public void render(PingPongBuffer buffer) {
        ((Convolve1DFilter)this.hor.setInput(buffer.capture())).render();
        ((Convolve1DFilter)this.vert.setInput(buffer.capture())).render();
    }
}

