/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.effects.CubmeapProjectionEffect;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class CubemapProjectionsFilter
extends Filter<CubemapProjectionsFilter> {
    private final ShaderProgram[] programs;
    private final Vector2 viewport;
    private float planetariumAperture;
    private float planetariumAngle;
    private float celestialSphereIndexOfRefraction;
    private CubmeapProjectionEffect.CubemapProjection projection;
    private TextureData[] cubemapSides;
    private int cmId = Integer.MIN_VALUE;

    public CubemapProjectionsFilter(float w, float h) {
        super(null);
        this.viewport = new Vector2(w, h);
        ShaderProgram equirectangular = ShaderLoader.fromFile("screenspace", "cubemapprojections", "#define equirectangular");
        ShaderProgram cylindrical = ShaderLoader.fromFile("screenspace", "cubemapprojections", "#define cylindrical");
        ShaderProgram hammeraitoff = ShaderLoader.fromFile("screenspace", "cubemapprojections", "#define hammer");
        ShaderProgram azimuthal = ShaderLoader.fromFile("screenspace", "cubemapprojections", "#define azimuthal");
        ShaderProgram orthographic = ShaderLoader.fromFile("screenspace", "cubemapprojections", "#define orthographic");
        ShaderProgram orthosphere = ShaderLoader.fromFile("screenspace", "cubemapprojections", "#define orthosphere");
        ShaderProgram orthosphere_crosseye = ShaderLoader.fromFile("screenspace", "cubemapprojections", "#define orthosphere_crosseye");
        this.programs = new ShaderProgram[7];
        this.programs[0] = equirectangular;
        this.programs[1] = cylindrical;
        this.programs[2] = hammeraitoff;
        this.programs[3] = orthographic;
        this.programs[4] = orthosphere;
        this.programs[5] = orthosphere_crosseye;
        this.programs[6] = azimuthal;
        this.program = equirectangular;
        this.rebind();
    }

    public CubmeapProjectionEffect.CubemapProjection getProjection() {
        return this.projection;
    }

    public void setProjection(CubmeapProjectionEffect.CubemapProjection proj) {
        this.projection = proj;
        switch (proj) {
            case EQUIRECTANGULAR: {
                this.program = this.programs[0];
                this.rebind();
                break;
            }
            case CYLINDRICAL: {
                this.program = this.programs[1];
                this.rebind();
                break;
            }
            case HAMMER: {
                this.program = this.programs[2];
                this.rebind();
                break;
            }
            case ORTHOGRAPHIC: {
                this.program = this.programs[3];
                this.rebind();
                break;
            }
            case ORTHOSPHERE: {
                this.program = this.programs[4];
                this.rebind();
                break;
            }
            case ORTHOSPHERE_CROSSEYE: {
                this.program = this.programs[5];
                this.rebind();
                break;
            }
            case AZIMUTHAL_EQUIDISTANT: {
                this.program = this.programs[6];
                this.rebind();
                break;
            }
        }
    }

    public void setSides(FrameBuffer xpositive, FrameBuffer xnegative, FrameBuffer ypositive, FrameBuffer ynegative, FrameBuffer zpositive, FrameBuffer znegative) {
        int i;
        this.cubemapSides = new TextureData[6];
        this.cubemapSides[0] = ((Texture)xpositive.getColorBufferTexture()).getTextureData();
        this.cubemapSides[1] = ((Texture)xnegative.getColorBufferTexture()).getTextureData();
        this.cubemapSides[2] = ((Texture)ypositive.getColorBufferTexture()).getTextureData();
        this.cubemapSides[3] = ((Texture)ynegative.getColorBufferTexture()).getTextureData();
        this.cubemapSides[4] = ((Texture)zpositive.getColorBufferTexture()).getTextureData();
        this.cubemapSides[5] = ((Texture)znegative.getColorBufferTexture()).getTextureData();
        FrameBuffer[] fbos = new FrameBuffer[]{xpositive, xnegative, ypositive, ynegative, zpositive, znegative};
        if (this.cmId < 0) {
            this.cmId = Gdx.gl.glGenTexture();
        }
        Gdx.gl.glActiveTexture(33985);
        Gdx.gl.glBindTexture(34067, this.cmId);
        for (i = 0; i < this.cubemapSides.length; ++i) {
            if (this.cubemapSides[i].getType() != TextureData.TextureDataType.Custom) continue;
            this.cubemapSides[i].consumeCustomData(34069 + i);
        }
        for (i = 0; i < this.cubemapSides.length; ++i) {
            fbos[i].begin();
            Gdx.gl.glFramebufferTexture2D(36160, 36064, 34069 + i, this.cmId, 0);
            fbos[i].end();
        }
        Gdx.gl.glTexParameteri(34067, 10240, 9729);
        Gdx.gl.glTexParameteri(34067, 10241, 9729);
        Gdx.gl.glTexParameteri(34067, 10242, 33071);
        Gdx.gl.glTexParameteri(34067, 10243, 33071);
        Gdx.gl.glBindTexture(34067, 0);
        this.setParam((Filter.Parameter)Param.Cubemap, 1);
    }

    public void setViewportSize(float width, float height) {
        this.viewport.set(width, height);
        this.setParam((Filter.Parameter)Param.Viewport, this.viewport);
    }

    public float getPlanetariumAperture() {
        return this.planetariumAperture;
    }

    public void setPlanetariumAperture(float ap) {
        this.planetariumAperture = ap;
        this.setParam((Filter.Parameter)Param.PlanetariumAperture, ap);
    }

    public float getPlanetariumAngle() {
        return this.planetariumAngle;
    }

    public void setPlanetariumAngle(float angle) {
        this.planetariumAngle = angle;
        this.setParam((Filter.Parameter)Param.PlanetariumAngle, angle);
    }

    public float getCelestialSphereIndexOfRefraction() {
        return this.celestialSphereIndexOfRefraction;
    }

    public void setCelestialSphereIndexOfRefraction(float ior) {
        this.celestialSphereIndexOfRefraction = ior;
        this.setParam((Filter.Parameter)Param.CelestialSphereIndexOfRefraction, ior);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Cubemap, 1);
        this.setParams((Filter.Parameter)Param.Viewport, this.viewport);
        this.setParams((Filter.Parameter)Param.PlanetariumAperture, this.planetariumAperture);
        this.setParams((Filter.Parameter)Param.PlanetariumAngle, this.planetariumAngle);
        this.setParams((Filter.Parameter)Param.CelestialSphereIndexOfRefraction, this.celestialSphereIndexOfRefraction);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        Gdx.gl.glActiveTexture(33985);
        Gdx.gl.glBindTexture(34067, this.cmId);
    }

    public static enum Param implements Filter.Parameter
    {
        Cubemap("u_cubemap", 0),
        Viewport("u_viewport", 2),
        PlanetariumAperture("u_planetariumAperture", 0),
        PlanetariumAngle("u_planetariumAngle", 0),
        CelestialSphereIndexOfRefraction("u_celestialSphereIndexOfRefraction", 1);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

