/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class DepthBufferFilter
extends Filter<DepthBufferFilter> {
    private Texture depthTexture;
    private final Vector2 zFarK = new Vector2();

    public DepthBufferFilter() {
        super(ShaderLoader.fromFile("screenspace", "depthbuffer"));
        this.rebind();
    }

    public void setDepthTexture(Texture tex) {
        this.depthTexture = tex;
        this.setParam((Filter.Parameter)Param.TextureDepth, 1);
    }

    public void setZFarK(float zFar, float k) {
        this.zFarK.set(zFar, k);
        this.setParam((Filter.Parameter)Param.ZFarK, this.zFarK);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.TextureDepth, 1);
        this.setParams((Filter.Parameter)Param.ZFarK, this.zFarK);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
        this.depthTexture.bind(1);
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        TextureDepth("u_texture1", 0),
        ZFarK("u_zFarK", 2);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

