/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.math.MathUtils;
import gaiasky.GaiaSky;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class FilmGrainFilter
extends Filter<FilmGrainFilter> {
    private float intensity;

    public FilmGrainFilter(float intensity) {
        super(ShaderLoader.fromFile("screenspace", "filmgrain"));
        this.intensity = intensity;
        this.rebind();
    }

    public void setIntensity(float intensity) {
        this.intensity = MathUtils.clamp((float)intensity, (float)0.0f, (float)1.0f);
        this.setParam((Filter.Parameter)Param.Intensity, intensity);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.Intensity, this.intensity);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
        this.setParam((Filter.Parameter)Param.Time, (float)GaiaSky.instance.getRunTimeSeconds());
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        Intensity("u_intensity", 0),
        Time("u_time", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

