/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.Vector4;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.render.postprocess.util.FullscreenQuad;
import gaiasky.render.util.ShaderLoader;

public abstract class Filter<T>
implements Disposable {
    protected static final FullscreenQuad quad = new FullscreenQuad();
    protected static final int u_texture0 = 0;
    protected static final int u_texture1 = 1;
    protected static final int u_texture2 = 2;
    protected static final int u_texture3 = 3;
    protected Texture inputTexture = null;
    protected FrameBuffer inputBuffer = null;
    protected FrameBuffer outputBuffer = null;
    protected ShaderProgram program;
    private boolean programBegan = false;
    protected String vertexShaderName;
    protected String fragmentShaderName;
    protected String defines;

    protected Filter(String vertex, String fragment, String defines) {
        this.vertexShaderName = vertex;
        this.fragmentShaderName = fragment;
        this.defines = defines;
        this.program = ShaderLoader.fromFile(vertex, fragment, defines);
    }

    protected Filter(String vertex, String fragment) {
        this(vertex, fragment, "");
    }

    protected Filter(ShaderProgram program) {
        this.program = program;
    }

    public T setInput(Texture input) {
        this.inputTexture = input;
        return (T)this;
    }

    public T setInput(FrameBuffer input) {
        this.inputBuffer = input;
        if (input != null) {
            return this.setInput((Texture)input.getColorBufferTexture());
        }
        return (T)this;
    }

    public T setOutput(FrameBuffer output) {
        this.outputBuffer = output;
        return (T)this;
    }

    public void updateProgram() {
        if (this.vertexShaderName != null && this.fragmentShaderName != null) {
            try {
                ShaderProgram program = ShaderLoader.fromFile(this.vertexShaderName, this.fragmentShaderName, this.defines);
                this.updateProgram(program);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateProgram(ShaderProgram program) {
        if (this.program != null) {
            this.program.dispose();
        }
        this.program = program;
        this.rebind();
    }

    public void dispose() {
        this.program.dispose();
    }

    public abstract void rebind();

    protected void setParam(Parameter param, boolean value) {
        this.program.bind();
        this.program.setUniformi(param.mnemonic(), value ? 1 : 0);
    }

    protected void setParam(Parameter param, int value) {
        this.program.bind();
        this.program.setUniformi(param.mnemonic(), value);
    }

    protected void setParam(Parameter param, float value) {
        this.program.bind();
        this.program.setUniformf(param.mnemonic(), value);
    }

    protected void setParam(Parameter param, Vector2 value) {
        this.program.bind();
        this.program.setUniformf(param.mnemonic(), value);
    }

    protected void setParam(Parameter param, Vector3 value) {
        this.program.bind();
        this.program.setUniformf(param.mnemonic(), value);
    }

    protected void setParam(Parameter param, Vector4 value) {
        this.program.bind();
        this.program.setUniformf(param.mnemonic(), value);
    }

    protected T setParam(Parameter param, Matrix3 value) {
        this.program.bind();
        this.program.setUniformMatrix(param.mnemonic(), value);
        return (T)this;
    }

    protected T setParam(Parameter param, Matrix4 value) {
        this.program.bind();
        this.program.setUniformMatrix(param.mnemonic(), value);
        return (T)this;
    }

    protected T setParamv(Parameter param, float[] values, int offset, int length) {
        this.program.bind();
        switch (param.arrayElementSize()) {
            case 4: {
                this.program.setUniform4fv(param.mnemonic(), values, offset, length);
                break;
            }
            case 3: {
                this.program.setUniform3fv(param.mnemonic(), values, offset, length);
                break;
            }
            case 2: {
                this.program.setUniform2fv(param.mnemonic(), values, offset, length);
                break;
            }
            case 1: {
                this.program.setUniform1fv(param.mnemonic(), values, offset, length);
            }
        }
        return (T)this;
    }

    protected T setParams(Parameter param, float value) {
        if (!this.programBegan) {
            this.programBegan = true;
            this.program.bind();
        }
        this.program.setUniformf(param.mnemonic(), value);
        return (T)this;
    }

    protected T setParams(Parameter param, boolean value) {
        if (!this.programBegan) {
            this.programBegan = true;
            this.program.bind();
        }
        this.program.setUniformi(param.mnemonic(), value ? 1 : 0);
        return (T)this;
    }

    protected T setParams(Parameter param, int value) {
        if (!this.programBegan) {
            this.programBegan = true;
            this.program.bind();
        }
        this.program.setUniformi(param.mnemonic(), value);
        return (T)this;
    }

    protected T setParams(Parameter param, Vector2 value) {
        if (!this.programBegan) {
            this.programBegan = true;
            this.program.bind();
        }
        this.program.setUniformf(param.mnemonic(), value);
        return (T)this;
    }

    protected T setParams(Parameter param, Vector3 value) {
        if (!this.programBegan) {
            this.programBegan = true;
            this.program.bind();
        }
        this.program.setUniformf(param.mnemonic(), value);
        return (T)this;
    }

    protected T setParams(Parameter param, Vector4 value) {
        if (!this.programBegan) {
            this.programBegan = true;
            this.program.bind();
        }
        this.program.setUniformf(param.mnemonic(), value);
        return (T)this;
    }

    protected T setParams(Parameter param, Matrix3 value) {
        if (!this.programBegan) {
            this.programBegan = true;
            this.program.bind();
        }
        this.program.setUniformMatrix(param.mnemonic(), value);
        return (T)this;
    }

    protected T setParams(Parameter param, Matrix4 value) {
        if (!this.programBegan) {
            this.programBegan = true;
            this.program.bind();
        }
        this.program.setUniformMatrix(param.mnemonic(), value);
        return (T)this;
    }

    protected T setParamsv(Parameter param, float[] values, int offset, int length) {
        if (!this.programBegan) {
            this.programBegan = true;
            this.program.bind();
        }
        switch (param.arrayElementSize()) {
            case 4: {
                this.program.setUniform4fv(param.mnemonic(), values, offset, length);
                break;
            }
            case 3: {
                this.program.setUniform3fv(param.mnemonic(), values, offset, length);
                break;
            }
            case 2: {
                this.program.setUniform2fv(param.mnemonic(), values, offset, length);
                break;
            }
            case 1: {
                this.program.setUniform1fv(param.mnemonic(), values, offset, length);
            }
        }
        return (T)this;
    }

    protected void endParams() {
        if (this.programBegan) {
            this.programBegan = false;
        }
    }

    protected abstract void onBeforeRender();

    public final void render() {
        if (this.outputBuffer != null) {
            this.outputBuffer.begin();
            this.realRender();
            this.outputBuffer.end();
        } else {
            this.realRender();
        }
    }

    protected void realRender() {
        this.onBeforeRender();
        this.program.bind();
        quad.render(this.program);
    }

    public static interface Parameter {
        public String mnemonic();

        public int arrayElementSize();
    }
}

