/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class FxaaFilter
extends Filter<FxaaFilter> {
    private final Vector2 viewportInverse;
    private final int quality;

    public FxaaFilter(float viewportWidth, float viewportHeight, int quality) {
        this(new Vector2(viewportWidth, viewportHeight), quality);
    }

    public FxaaFilter(int viewportWidth, int viewportHeight) {
        this(new Vector2((float)viewportWidth, (float)viewportHeight), 2);
    }

    public FxaaFilter(Vector2 viewportSize, int quality) {
        super(ShaderLoader.fromFile("screenspace", "fxaa", "#define FXAA_PRESET " + (quality % 3 + 3)));
        this.quality = quality;
        this.viewportInverse = viewportSize;
        this.viewportInverse.x = 1.0f / this.viewportInverse.x;
        this.viewportInverse.y = 1.0f / this.viewportInverse.y;
        this.rebind();
    }

    public void updateQuality(int quality) {
        super.updateProgram(ShaderLoader.fromFile("screenspace", "fxaa", "#define FXAA_PRESET " + (quality % 3 + 3)));
    }

    public void setViewportSize(float width, float height) {
        this.viewportInverse.set(1.0f / width, 1.0f / height);
        this.setParam((Filter.Parameter)Param.ViewportInverse, this.viewportInverse);
    }

    public Vector2 getViewportSize() {
        return this.viewportInverse;
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.ViewportInverse, this.viewportInverse);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
    }

    @Override
    public void updateProgram() {
        super.updateProgram(ShaderLoader.fromFile("screenspace", "fxaa", "#define FXAA_PRESET " + (this.quality % 3 + 3)));
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        ViewportInverse("u_viewportInverse", 2);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

