/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class GlowFilter
extends Filter<GlowFilter> {
    private final Vector2 viewport;
    private float[] lightPositions;
    private float[] lightViewAngles;
    private float[] lightColors;
    private int nLights = 0;
    private int nSamples = 30;
    private float textureScale = 1.0f;
    private float spiralScale = 1.0f;
    private float orientation = 0.0f;
    private float backbufferScale = 1.0f;
    private Texture occlusionTexture;
    private Texture lightGlowTexture;

    public GlowFilter(int width, int height) {
        super(ShaderLoader.fromFile("lightglow", "lightglow"));
        this.viewport = new Vector2((float)width, (float)height);
        this.rebind();
    }

    public void setBackbufferScale(float s) {
        this.backbufferScale = s;
        this.setParam((Filter.Parameter)Param.BackbufferScale, s);
    }

    public void setViewportSize(float width, float height) {
        this.viewport.set(width, height);
        this.setParam((Filter.Parameter)Param.Viewport, this.viewport);
    }

    public void setLightPositions(int nLights, float[] vec) {
        this.setNLights(nLights);
        this.lightPositions = vec;
        this.setParamv(Param.LightPositions, this.lightPositions, 0, this.nLights * 2);
    }

    public void setNLights(int nLights) {
        this.nLights = nLights;
        this.setParam((Filter.Parameter)Param.NLights, this.nLights);
    }

    public void setLightViewAngles(float[] ang) {
        this.lightViewAngles = ang;
        this.setParamv(Param.LightViewAngles, this.lightViewAngles, 0, this.nLights);
    }

    public void setLightColors(float[] colors) {
        this.lightColors = colors;
        this.setParamv(Param.LightColors, this.lightColors, 0, this.nLights * 3);
    }

    public void setNSamples(int nSamples) {
        this.nSamples = nSamples;
        this.setParam((Filter.Parameter)Param.NSamples, nSamples);
    }

    public void setTextureScale(float scl) {
        this.textureScale = scl;
        this.setParam((Filter.Parameter)Param.TextureScale, this.textureScale);
    }

    public void setSpiralScale(float scl) {
        this.spiralScale = scl;
        this.setParam((Filter.Parameter)Param.SpiralScale, this.spiralScale);
    }

    public Texture getLightGlowTexture() {
        return this.lightGlowTexture;
    }

    public void setLightGlowTexture(Texture tex) {
        this.lightGlowTexture = tex;
        this.setParam((Filter.Parameter)Param.LightGlowTexture, 1);
    }

    public Texture getOcclusionTexture() {
        return this.occlusionTexture;
    }

    public void setOcclusionTexture(Texture tex) {
        this.occlusionTexture = tex;
        this.setParam((Filter.Parameter)Param.OcclusionTexture, 2);
    }

    public void setOrientation(float o) {
        this.orientation = o;
        this.setParam((Filter.Parameter)Param.Orientation, o);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.LightGlowTexture, 1);
        this.setParams((Filter.Parameter)Param.OcclusionTexture, 2);
        this.setParams((Filter.Parameter)Param.NSamples, this.nSamples);
        this.setParams((Filter.Parameter)Param.TextureScale, this.textureScale);
        this.setParams((Filter.Parameter)Param.SpiralScale, this.spiralScale);
        this.setParams((Filter.Parameter)Param.Orientation, this.orientation);
        this.setParams((Filter.Parameter)Param.Viewport, this.viewport);
        this.setParams((Filter.Parameter)Param.BackbufferScale, this.backbufferScale);
        this.setParams((Filter.Parameter)Param.NLights, this.nLights);
        if (this.lightPositions != null) {
            this.setParamsv(Param.LightPositions, this.lightPositions, 0, this.nLights * 2);
        }
        if (this.lightViewAngles != null) {
            this.setParamsv(Param.LightViewAngles, this.lightViewAngles, 0, this.nLights);
        }
        if (this.lightColors != null) {
            this.setParamsv(Param.LightColors, this.lightColors, 0, this.nLights * 3);
        }
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        if (this.lightGlowTexture != null) {
            this.lightGlowTexture.bind(1);
        }
        if (this.occlusionTexture != null) {
            this.occlusionTexture.bind(2);
        }
        this.inputTexture.bind(0);
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        LightGlowTexture("u_texture1", 0),
        OcclusionTexture("u_texture2", 0),
        LightPositions("u_lightPositions", 2),
        LightViewAngles("u_lightViewAngles", 1),
        LightColors("u_lightColors", 3),
        Viewport("u_viewport", 2),
        NLights("u_nLights", 0),
        NSamples("u_nSamples", 0),
        Orientation("u_orientation", 0),
        SpiralScale("u_spiralScale", 0),
        BackbufferScale("u_backbufferScale", 0),
        TextureScale("u_textureScale", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

