/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class GravitationalDistortionFilter
extends Filter<GravitationalDistortionFilter> {
    private final Vector2 viewport;
    private final Vector2 massPosition;

    public GravitationalDistortionFilter(Vector2 viewportSize) {
        super(ShaderLoader.fromFile("screenspace", "gravitydistortion"));
        this.viewport = viewportSize;
        this.massPosition = new Vector2();
        this.rebind();
    }

    public GravitationalDistortionFilter(int viewportWidth, int viewportHeight) {
        this(new Vector2((float)viewportWidth, (float)viewportHeight));
    }

    public void setViewportSize(float width, float height) {
        this.viewport.set(width, height);
        this.setParam((Filter.Parameter)Param.Viewport, this.viewport);
    }

    public void setMassPosition(float x, float y) {
        this.massPosition.set(x, y);
        this.setParam((Filter.Parameter)Param.MassPosition, this.massPosition);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.Viewport, this.viewport);
        this.setParams((Filter.Parameter)Param.MassPosition, this.massPosition);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        Viewport("u_viewport", 2),
        MassPosition("u_massPosition", 2);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

