/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import gaiasky.render.postprocess.filters.Filter;

public final class LensDirtFilter
extends Filter<LensDirtFilter> {
    private Texture lensDirtTexture;
    private Texture lensStarburstTexture;
    private float starburstOffset;

    public LensDirtFilter() {
        super("screenspace", "lensdirt");
        this.rebind();
    }

    public void setLensDirtTexture(Texture tex) {
        this.lensDirtTexture = tex;
        this.setParam((Filter.Parameter)Param.LensDirt, 1);
    }

    public void setLensStarburstTexture(Texture tex) {
        this.lensStarburstTexture = tex;
        this.setParam((Filter.Parameter)Param.LensStarburst, 2);
    }

    public void setStarburstOffset(float offset) {
        this.starburstOffset = offset;
        this.setParam((Filter.Parameter)Param.StarburstOffset, offset);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.LensDirt, 1);
        this.setParams((Filter.Parameter)Param.LensStarburst, 2);
        this.setParams((Filter.Parameter)Param.StarburstOffset, this.starburstOffset);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
        this.lensDirtTexture.bind(1);
        if (this.lensStarburstTexture != null) {
            this.lensStarburstTexture.bind(2);
        }
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        LensDirt("u_texture1", 0),
        LensStarburst("u_texture2", 0),
        StarburstOffset("u_starburstOffset", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

