/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import gaiasky.render.postprocess.filters.Filter;

public final class LensFlareFilter
extends Filter<LensFlareFilter> {
    private final Vector2 viewport;
    private float[] lightPositions;
    private int nLights = 0;
    private final Vector3 color;
    private float intensity;

    public LensFlareFilter(int width, int height, float intensity, int type, boolean useLensDirt) {
        super("screenspace", "lensflare", LensFlareFilter.getDefines(type, useLensDirt));
        this.viewport = new Vector2((float)width, (float)height);
        this.intensity = intensity;
        this.color = new Vector3(1.0f, 1.0f, 1.0f);
        this.rebind();
    }

    private static String getDefines(int type, boolean useLensDirt) {
        StringBuilder sb = new StringBuilder();
        if (type == 0) {
            sb.append("#define simpleLensFlare\n");
        } else {
            sb.append("#define complexLensFlare\n");
        }
        if (useLensDirt) {
            sb.append("#define useLensDirt\n");
        }
        return sb.toString();
    }

    public void setViewportSize(float width, float height) {
        this.viewport.set(width, height);
        this.setParam((Filter.Parameter)Param.Viewport, this.viewport);
    }

    public void setLightPositions(int nLights, float[] positions, float[] intensities) {
        this.nLights = nLights;
        this.lightPositions = positions;
        this.setParam((Filter.Parameter)Param.NLights, this.nLights);
        this.setParamv(Param.LightPositions, this.lightPositions, 0, this.nLights * 2);
        this.setParamv(Param.LightIntensities, intensities, 0, this.nLights);
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
        this.setParam((Filter.Parameter)Param.Intensity, this.intensity);
    }

    public void setColor(float[] color) {
        this.color.set(color);
        this.setParam((Filter.Parameter)Param.Color, this.color);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.Viewport, this.viewport);
        this.setParams((Filter.Parameter)Param.Intensity, this.intensity);
        this.setParams((Filter.Parameter)Param.Color, this.color);
        this.setParams((Filter.Parameter)Param.NLights, this.nLights);
        if (this.lightPositions != null) {
            this.setParamsv(Param.LightPositions, this.lightPositions, 0, this.nLights * 2);
        }
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        LightPositions("u_lightPositions", 2),
        LightIntensities("u_lightIntensities", 1),
        NLights("u_nLights", 0),
        Color("u_color", 3),
        Intensity("u_intensity", 0),
        Viewport("u_viewport", 2);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

