/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class LevelsFilter
extends Filter<LevelsFilter> {
    private final ShaderProgram programRegular = this.program;
    private final ShaderProgram programToneMappingExposure = ShaderLoader.fromFile("screenspace", "levels", "#define toneMappingExposure");
    private final ShaderProgram programToneMappingAuto = ShaderLoader.fromFile("screenspace", "levels", "#define toneMappingAuto");
    private final ShaderProgram programToneMappingACES = ShaderLoader.fromFile("screenspace", "levels", "#define toneMappingACES");
    private final ShaderProgram programToneMappingUncharted = ShaderLoader.fromFile("screenspace", "levels", "#define toneMappingUncharted");
    private final ShaderProgram programToneMappingFilmic = ShaderLoader.fromFile("screenspace", "levels", "#define toneMappingFilmic");
    private float brightness = 0.0f;
    private float contrast = 1.0f;
    private float saturation = 1.0f;
    private float hue = 1.0f;
    private float gamma = 1.0f;
    private float exposure = 1.0f;
    private float avgLuma;
    private float maxLuma;

    public LevelsFilter() {
        super(ShaderLoader.fromFile("screenspace", "levels"));
        this.rebind();
    }

    public void setContrast(float contrast) {
        this.contrast = contrast;
        this.setParam((Filter.Parameter)Param.Contrast, this.contrast);
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
        this.setParam((Filter.Parameter)Param.Brightness, this.brightness);
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
        this.setParam((Filter.Parameter)Param.Saturation, this.saturation);
    }

    public void setHue(float hue) {
        this.hue = hue;
        this.setParam((Filter.Parameter)Param.Hue, this.hue);
    }

    public void setGamma(float gamma) {
        this.gamma = gamma;
        this.setParam((Filter.Parameter)Param.Gamma, this.gamma);
    }

    public void setExposure(float exposure) {
        this.exposure = exposure;
        this.setParam((Filter.Parameter)Param.Exposure, this.exposure);
    }

    public void setAvgMaxLuma(float avgLuma, float maxLuma) {
        this.avgLuma = avgLuma;
        this.maxLuma = maxLuma;
        this.setParam((Filter.Parameter)Param.AvgLuma, this.avgLuma);
        this.setParam((Filter.Parameter)Param.MaxLuma, this.maxLuma);
    }

    public void enableToneMappingExposure() {
        this.program = this.programToneMappingExposure;
        this.rebind();
    }

    public void enableToneMappingAuto() {
        this.program = this.programToneMappingAuto;
        this.rebind();
    }

    public void enableToneMappingACES() {
        this.program = this.programToneMappingACES;
        this.rebind();
    }

    public void enableToneMappingUncharted() {
        this.program = this.programToneMappingUncharted;
        this.rebind();
    }

    public void enableToneMappingFilmic() {
        this.program = this.programToneMappingFilmic;
        this.rebind();
    }

    public boolean isToneMappingAuto() {
        return this.program == this.programToneMappingAuto;
    }

    public void disableToneMapping() {
        this.program = this.programRegular;
        this.rebind();
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.Brightness, this.brightness);
        this.setParams((Filter.Parameter)Param.Contrast, this.contrast);
        this.setParams((Filter.Parameter)Param.Saturation, this.saturation);
        this.setParams((Filter.Parameter)Param.Hue, this.hue);
        this.setParams((Filter.Parameter)Param.Gamma, this.gamma);
        if (this.programToneMappingExposure != null && this.program == this.programToneMappingExposure) {
            this.setParams((Filter.Parameter)Param.Exposure, this.exposure);
        }
        if (this.programToneMappingAuto != null && this.program == this.programToneMappingAuto) {
            this.setParams((Filter.Parameter)Param.AvgLuma, this.avgLuma);
            this.setParams((Filter.Parameter)Param.MaxLuma, this.maxLuma);
        }
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        Brightness("u_brightness", 0),
        Contrast("u_contrast", 0),
        Saturation("u_saturation", 0),
        Hue("u_hue", 0),
        Exposure("u_exposure", 0),
        AvgLuma("u_avgLuma", 0),
        MaxLuma("u_maxLuma", 0),
        Gamma("u_gamma", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

