/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class LightScatteringFilter
extends Filter<LightScatteringFilter> {
    public static int N = 10;
    private final Vector2 viewport;
    int NUM_SAMPLES = 100;
    private float[] lightPositions = new float[N * 2];
    private float[] lightViewAngles = new float[N];
    private int nLights;
    private float decay = 0.96815f;
    private float density = 0.926f;
    private float weight = 0.58767f;
    private int numSamples = 100;

    public LightScatteringFilter(int width, int height) {
        super(ShaderLoader.fromFile("screenspace", "lightscattering"));
        this.viewport = new Vector2((float)width, (float)height);
        this.rebind();
    }

    public void setViewportSize(float width, float height) {
        this.viewport.set(width, height);
        this.setParam((Filter.Parameter)Param.Viewport, this.viewport);
    }

    public void setLightPositions(int nLights, float[] pos) {
        this.nLights = nLights;
        this.lightPositions = pos;
        this.setParam((Filter.Parameter)Param.NLights, this.nLights);
        this.setParamv(Param.LightPositions, this.lightPositions, 0, N * 2);
    }

    public void setLightViewAngles(float[] ang) {
        this.lightViewAngles = ang;
        this.setParamv(Param.LightViewAngles, this.lightViewAngles, 0, N);
    }

    public float getDecay() {
        return this.decay;
    }

    public void setDecay(float decay) {
        this.decay = decay;
        this.setParam((Filter.Parameter)Param.Decay, decay);
    }

    public float getDensity() {
        return this.density;
    }

    public void setDensity(float density) {
        this.density = density;
        this.setParam((Filter.Parameter)Param.Density, density);
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
        this.setParam((Filter.Parameter)Param.Weight, weight);
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
        this.setParam((Filter.Parameter)Param.NumSamples, numSamples);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.NLights, this.nLights);
        this.setParams((Filter.Parameter)Param.Viewport, this.viewport);
        this.setParamsv(Param.LightPositions, this.lightPositions, 0, N * 2);
        this.setParamsv(Param.LightViewAngles, this.lightViewAngles, 0, N);
        this.setParams((Filter.Parameter)Param.Decay, this.decay);
        this.setParams((Filter.Parameter)Param.Density, this.density);
        this.setParams((Filter.Parameter)Param.Weight, this.weight);
        this.setParams((Filter.Parameter)Param.NumSamples, this.numSamples);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        LightPositions("u_lightPositions", 2),
        LightViewAngles("u_lightViewAngles", 1),
        Viewport("u_viewport", 2),
        NLights("u_nLights", 0),
        Decay("u_decay", 0),
        Density("u_density", 0),
        Weight("u_weight", 0),
        NumSamples("u_numSamples", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

