/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public class LumaFilter
extends Filter<LumaFilter> {
    private final Vector2 texelSize;
    private final Vector2 imageSize;
    private final ShaderProgram programLuma = this.program;
    private final ShaderProgram programAvg = ShaderLoader.fromFile("screenspace", "luma", "#define AVERAGE");
    private final ShaderProgram programMax = ShaderLoader.fromFile("screenspace", "luma", "#define MAX");
    private float lodLevel = 0.0f;

    public LumaFilter() {
        super(ShaderLoader.fromFile("screenspace", "luma", "#define LUMA"));
        this.texelSize = new Vector2();
        this.imageSize = new Vector2();
    }

    public void enableProgramLuma() {
        this.program = this.programLuma;
        this.rebind();
    }

    public void enableProgramAvg() {
        this.program = this.programAvg;
        this.rebind();
    }

    public void enableProgramMax() {
        this.program = this.programMax;
        this.rebind();
    }

    public void setImageSize(float w, float h) {
        this.imageSize.set(w, h);
        this.setParam((Filter.Parameter)Param.ImageSize, this.texelSize);
    }

    public void setTexelSize(float u, float v) {
        this.texelSize.set(u, v);
        this.setParam((Filter.Parameter)Param.TexelSize, this.texelSize);
    }

    public void setLodLevel(float lodLevel) {
        this.lodLevel = lodLevel;
        this.setParam((Filter.Parameter)Param.LodLevel, lodLevel);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture0, 0);
        this.setParams((Filter.Parameter)Param.TexelSize, this.texelSize);
        this.setParams((Filter.Parameter)Param.ImageSize, this.texelSize);
        this.setParams((Filter.Parameter)Param.LodLevel, this.lodLevel);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
    }

    public static enum Param implements Filter.Parameter
    {
        Texture0("u_texture0", 0),
        ImageSize("u_imageSize", 2),
        TexelSize("u_texelSize", 2),
        LodLevel("u_lodLevel", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String m, int elementSize) {
            this.mnemonic = m;
            this.elementSize = elementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

