/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class MosaicFilter
extends Filter<MosaicFilter> {
    private final Vector2 viewport;
    private final Texture[] tiles = new Texture[4];

    public MosaicFilter(float w, float h) {
        super(null);
        this.viewport = new Vector2(w, h);
        this.program = ShaderLoader.fromFile("screenspace", "mosaic", "");
        this.rebind();
    }

    public void setTiles(FrameBuffer topLeft, FrameBuffer bottomLeft, FrameBuffer topRight, FrameBuffer bottomRight) {
        this.tiles[0] = (Texture)topLeft.getColorBufferTexture();
        this.tiles[1] = (Texture)bottomLeft.getColorBufferTexture();
        this.tiles[2] = (Texture)topRight.getColorBufferTexture();
        this.tiles[3] = (Texture)bottomRight.getColorBufferTexture();
        this.setParam((Filter.Parameter)Param.Texture0, 0);
        this.setParam((Filter.Parameter)Param.Texture1, 1);
        this.setParam((Filter.Parameter)Param.Texture2, 2);
        this.setParam((Filter.Parameter)Param.Texture3, 3);
    }

    public void setViewportSize(float width, float height) {
        this.viewport.set(width, height);
        this.setParam((Filter.Parameter)Param.Viewport, this.viewport);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture0, 0);
        this.setParams((Filter.Parameter)Param.Texture1, 1);
        this.setParams((Filter.Parameter)Param.Texture2, 2);
        this.setParams((Filter.Parameter)Param.Texture3, 3);
        this.setParams((Filter.Parameter)Param.Viewport, this.viewport);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        for (int i = 0; i < 4; ++i) {
            this.tiles[i].bind(0 + i);
        }
    }

    public static enum Param implements Filter.Parameter
    {
        Texture0("u_texture0", 0),
        Texture1("u_texture1", 0),
        Texture2("u_texture2", 0),
        Texture3("u_texture3", 0),
        Viewport("u_viewport", 2);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

