/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.Vector4;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class NoiseFilter
extends Filter<NoiseFilter> {
    private final Vector2 viewport;
    private final Vector3 scale = new Vector3(1.0f, 1.0f, 1.0f);
    private final Vector2 range = new Vector2(0.0f, 1.0f);
    private final Vector4 color = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);
    private float seed = 1.23456f;
    private float amplitude = 1.0f;
    private float persistence = 0.5f;
    private float frequency = 1.0f;
    private float lacunarity = 2.0f;
    private float power = 1.3f;
    private int octaves = 4;
    private boolean turbulence = true;
    private boolean ridge = false;
    private int numTerraces = 0;
    private float terraceExp = 17.0f;
    private int channels = 1;
    private NoiseType type = NoiseType.SIMPLEX;

    public NoiseFilter(int viewportWidth, int viewportHeight, int targets) {
        this(new Vector2((float)viewportWidth, (float)viewportHeight), targets);
    }

    public NoiseFilter(Vector2 viewportSize, int targets) {
        super(ShaderLoader.fromFile("screenspace", "noise", targets > 1 ? "#define extraTarget\n" : ""));
        this.viewport = viewportSize;
        this.rebind();
    }

    public void setViewportSize(float width, float height) {
        this.viewport.set(width, height);
        this.setParam((Filter.Parameter)Param.Viewport, this.viewport);
    }

    public void setColor(float r, float g, float b, float a) {
        this.color.set(r, g, b, a);
        this.setParam((Filter.Parameter)Param.Color, this.color);
    }

    public void setRange(float a, float b) {
        this.range.set(a, b);
        this.setParam((Filter.Parameter)Param.Range, this.range);
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.scale.set(scaleX, scaleY, scaleZ);
        this.setParam((Filter.Parameter)Param.Scale, this.scale);
    }

    public void setScale(float scale) {
        this.setScale(scale, scale, scale);
    }

    public void setSeed(float seed) {
        this.seed = seed;
        this.setParam((Filter.Parameter)Param.Seed, this.seed);
    }

    public void setAmplitude(float a) {
        this.amplitude = a;
        this.setParam((Filter.Parameter)Param.Amplitude, this.amplitude);
    }

    public void setPersistence(float p) {
        this.persistence = p;
        this.setParam((Filter.Parameter)Param.Persistence, this.persistence);
    }

    public void setFrequency(float f) {
        this.frequency = f;
        this.setParam((Filter.Parameter)Param.Frequency, this.frequency);
    }

    public void setLacunarity(float lacunarity) {
        this.lacunarity = lacunarity;
        this.setParam((Filter.Parameter)Param.Lacunarity, this.lacunarity);
    }

    public void setPower(float power) {
        this.power = power;
        this.setParam((Filter.Parameter)Param.Power, this.power);
    }

    public void setOctaves(int octaves) {
        this.octaves = octaves;
        this.setParam((Filter.Parameter)Param.Octaves, this.octaves);
    }

    public void setTurbulence(boolean turbulence) {
        this.turbulence = turbulence;
        this.setParam((Filter.Parameter)Param.Turbulence, this.turbulence);
    }

    public void setRidge(boolean ridge) {
        this.ridge = ridge;
        this.setParam((Filter.Parameter)Param.Ridge, this.ridge);
    }

    public void setNumTerraces(int nt) {
        this.numTerraces = nt;
        this.setParam((Filter.Parameter)Param.NumTerraces, this.numTerraces);
    }

    public void setTerraceExp(float te) {
        this.terraceExp = te;
        this.setParam((Filter.Parameter)Param.TerraceExp, this.terraceExp);
    }

    public void setChannels(int channels) {
        this.channels = channels;
        this.setParam((Filter.Parameter)Param.Channels, this.channels);
    }

    public void setType(NoiseType type) {
        this.type = type;
        this.setParam((Filter.Parameter)Param.Type, this.type.ordinal());
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.Viewport, this.viewport);
        this.setParams((Filter.Parameter)Param.Range, this.range);
        this.setParams((Filter.Parameter)Param.Color, this.color);
        this.setParams((Filter.Parameter)Param.Scale, this.scale);
        this.setParams((Filter.Parameter)Param.Seed, this.seed);
        this.setParams((Filter.Parameter)Param.Amplitude, this.amplitude);
        this.setParams((Filter.Parameter)Param.Persistence, this.persistence);
        this.setParams((Filter.Parameter)Param.Frequency, this.frequency);
        this.setParams((Filter.Parameter)Param.Lacunarity, this.lacunarity);
        this.setParams((Filter.Parameter)Param.Power, this.power);
        this.setParams((Filter.Parameter)Param.Octaves, this.octaves);
        this.setParams((Filter.Parameter)Param.Turbulence, this.turbulence);
        this.setParams((Filter.Parameter)Param.Ridge, this.ridge);
        this.setParams((Filter.Parameter)Param.NumTerraces, this.numTerraces);
        this.setParams((Filter.Parameter)Param.TerraceExp, this.terraceExp);
        this.setParams((Filter.Parameter)Param.Channels, this.channels);
        this.setParams((Filter.Parameter)Param.Type, this.type.ordinal());
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        if (this.inputTexture != null) {
            this.inputTexture.bind(0);
        }
    }

    public static enum NoiseType {
        PERLIN,
        SIMPLEX,
        VORONOI,
        CURL,
        WHITE;

    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        Viewport("u_viewport", 2),
        Seed("u_seed", 0),
        Amplitude("u_amplitude", 0),
        Persistence("u_persistence", 0),
        Frequency("u_frequency", 0),
        Lacunarity("u_lacunarity", 0),
        Range("u_range", 2),
        Color("u_color", 4),
        Scale("u_scale", 3),
        Power("u_power", 0),
        Octaves("u_octaves", 0),
        Turbulence("u_turbulence", 0),
        Ridge("u_ridge", 0),
        NumTerraces("u_numTerraces", 0),
        TerraceExp("u_terraceExp", 0),
        Channels("u_channels", 0),
        Type("u_type", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

