/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import gaiasky.render.postprocess.filters.Filter3;
import gaiasky.render.util.ShaderLoader;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import net.jafama.FastMath;

public final class RaymarchingFilter
extends Filter3<RaymarchingFilter> {
    private final Vector2 viewport;
    private final Vector2 zfark;
    private final Vector3 pos;
    private final float[] additional;
    private Matrix4 frustumCorners;
    private final Matrix4 invView;
    private final Matrix4 combined;
    private float timeSecs;
    private final float distanceScale;
    private float size;
    private Texture depthTexture;
    private Texture additionalTexture;

    public RaymarchingFilter(String fragmentShader, int viewportWidth, int viewportHeight) {
        this(fragmentShader, new Vector2((float)viewportWidth, (float)viewportHeight));
    }

    public RaymarchingFilter(String fragmentShader, Vector2 viewportSize) {
        super("raymarching/screenspace", fragmentShader);
        this.viewport = viewportSize;
        this.zfark = new Vector2();
        this.pos = new Vector3();
        this.frustumCorners = new Matrix4();
        this.invView = new Matrix4();
        this.combined = new Matrix4();
        this.additional = new float[4];
        this.distanceScale = (float)Constants.DISTANCE_SCALE_FACTOR;
        this.size = 1.0f;
        this.rebind();
    }

    @Override
    public void updateProgram() {
        try {
            ShaderProgram program = ShaderLoader.fromFile("raymarching/screenspace", this.fragmentShaderName);
            this.updateProgram(program);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFrustumCorners(Matrix4 fc) {
        this.frustumCorners = fc;
        this.setParam((Filter3.Parameter)Param.FrustumCorners, this.frustumCorners);
    }

    public void setView(Matrix4 view) {
        this.invView.set(view).inv();
        this.setParam((Filter3.Parameter)Param.InvView, this.invView);
    }

    public void setCombined(Matrix4 viewProjection) {
        this.combined.set(viewProjection);
        this.setParam((Filter3.Parameter)Param.Combined, this.combined);
    }

    public void setPos(Vector3 pos) {
        this.pos.set(pos);
        this.setParam((Filter3.Parameter)Param.Pos, this.pos);
    }

    public void setTime(float seconds) {
        this.timeSecs = seconds;
        this.setParam((Filter3.Parameter)Param.Time, this.timeSecs);
    }

    public void setSize(float size) {
        this.size = size;
        this.setParam((Filter3.Parameter)Param.Size, size);
    }

    public void setViewportSize(float width, float height) {
        this.viewport.set(width, height);
        this.setParam((Filter3.Parameter)Param.Viewport, this.viewport);
    }

    public void setZfarK(float zfar, float k) {
        this.zfark.set(zfar, k);
        this.setParam((Filter3.Parameter)Param.ZfarK, this.zfark);
    }

    public void setDepthTexture(Texture tex) {
        this.depthTexture = tex;
        this.setParam((Filter3.Parameter)Param.TextureDepth, 1);
    }

    public void setAdditionalTexture(Texture tex) {
        this.additionalTexture = tex;
        this.setParam((Filter3.Parameter)Param.TextureAdditional, 2);
    }

    public void setAdditional(float[] additional) {
        int len = FastMath.min((int)additional.length, (int)4);
        System.arraycopy(additional, 0, this.additional, 0, len);
        this.setParamv(Param.Additional, this.additional, 0, 4);
    }

    public void setAdditional(float a, float b, float c, float d) {
        this.additional[0] = a;
        this.additional[1] = b;
        this.additional[2] = c;
        this.additional[3] = d;
        this.setParamv(Param.Additional, this.additional, 0, 4);
    }

    public void setAdditional(int index, float value) {
        if (index >= 0 && index < 4) {
            this.additional[index] = value;
            this.setParamv(Param.Additional, this.additional, 0, 4);
        } else {
            Logger.getLogger(RaymarchingFilter.class).error("Additional index must be in [0, 3]: " + index);
        }
    }

    public Vector2 getViewportSize() {
        return this.viewport;
    }

    @Override
    public void rebind() {
        this.setParams((Filter3.Parameter)Param.Texture, 0);
        this.setParams((Filter3.Parameter)Param.TextureDepth, 1);
        this.setParams((Filter3.Parameter)Param.TextureAdditional, 2);
        this.setParams((Filter3.Parameter)Param.Viewport, this.viewport);
        this.setParams((Filter3.Parameter)Param.ZfarK, this.zfark);
        this.setParams((Filter3.Parameter)Param.FrustumCorners, this.frustumCorners);
        this.setParams((Filter3.Parameter)Param.InvView, this.invView);
        this.setParams((Filter3.Parameter)Param.Combined, this.combined);
        this.setParams((Filter3.Parameter)Param.Pos, this.pos);
        this.setParams((Filter3.Parameter)Param.Time, this.timeSecs);
        this.setParams((Filter3.Parameter)Param.Size, this.size);
        this.setParams((Filter3.Parameter)Param.DistanceScale, this.distanceScale);
        this.setParamsv(Param.Additional, this.additional, 0, 4);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        if (this.inputTexture != null) {
            this.inputTexture.bind(0);
        }
        if (this.depthTexture != null) {
            this.depthTexture.bind(1);
        }
        if (this.additionalTexture != null) {
            this.additionalTexture.bind(2);
        }
    }

    public static enum Param implements Filter3.Parameter
    {
        Texture("u_texture0", 0),
        TextureDepth("u_texture1", 0),
        TextureAdditional("u_texture2", 0),
        Time("u_time", 1),
        Size("u_size", 1),
        DistanceScale("u_distScale", 1),
        Viewport("u_viewport", 2),
        ZfarK("u_zfark", 2),
        Pos("u_pos", 3),
        InvView("u_invView", 16),
        Combined("u_modelView", 16),
        FrustumCorners("u_frustumCorners", 16),
        Additional("u_additional", 4);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

