/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;
import net.jafama.FastMath;

public final class ReprojectionFilter
extends Filter<ReprojectionFilter> {
    private final Vector2 viewport;
    private float fov;
    private int mode = 0;

    public ReprojectionFilter(float width, float height) {
        super(ShaderLoader.fromFile("screenspace", "reprojection"));
        this.viewport = new Vector2(width, height);
        this.rebind();
    }

    public ReprojectionFilter(int width, int height) {
        this((float)width, (float)height);
    }

    public void setViewportSize(float width, float height) {
        this.viewport.set(width, height);
        this.setParam((Filter.Parameter)Param.Viewport, this.viewport);
    }

    public void setFov(float fovDegrees) {
        this.fov = (float)FastMath.toRadians((double)fovDegrees);
        this.setParam((Filter.Parameter)Param.Fov, this.fov);
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.setParam((Filter.Parameter)Param.Mode, this.mode);
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture0, 0);
        this.setParams((Filter.Parameter)Param.Viewport, this.viewport);
        this.setParams((Filter.Parameter)Param.Fov, this.fov);
        this.setParams((Filter.Parameter)Param.Mode, this.mode);
        this.endParams();
    }

    public static enum Param implements Filter.Parameter
    {
        Texture0("u_texture0", 0),
        Fov("u_fov", 0),
        Mode("u_mode", 0),
        Viewport("u_viewport", 2);

        private final String mnemonic;
        private final int elementSize;

        private Param(String m, int elementSize) {
            this.mnemonic = m;
            this.elementSize = elementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

