/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.filters.Filter3;

public class SSRFilter
extends Filter3<SSRFilter> {
    private final Vector2 zFarK = new Vector2();
    private Matrix4 frustumCorners = new Matrix4();
    private final Matrix4 combined;
    private final Matrix4 projection = new Matrix4();
    private final Matrix4 invProjection = new Matrix4();
    private final Matrix4 view = new Matrix4();
    private final Matrix4 invView = new Matrix4();
    private Texture texture1;
    private Texture texture2;
    private Texture texture3;

    public SSRFilter() {
        super("raymarching/screenspace", "ssr");
        this.combined = new Matrix4();
        this.rebind();
    }

    public void setNormalTexture(Texture tex) {
        this.setTexture2(tex);
    }

    public void setReflectionTexture(Texture tex) {
        this.setTexture3(tex);
    }

    public void setFrustumCorners(Matrix4 fc) {
        this.frustumCorners = fc;
        this.setParam((Filter3.Parameter)Param.FrustumCorners, this.frustumCorners);
    }

    public void setProjection(Matrix4 proj) {
        this.projection.set(proj);
        this.invProjection.set(proj).inv();
        this.setParam((Filter3.Parameter)Param.Projection, this.projection);
        this.setParam((Filter3.Parameter)Param.InvProjection, this.invProjection);
    }

    public void setCombined(Matrix4 mv) {
        this.combined.set(mv);
        this.setParam((Filter3.Parameter)Param.Combined, this.combined);
    }

    public void setView(Matrix4 view) {
        if (view != null) {
            try {
                this.view.set(view);
                this.setParam((Filter3.Parameter)Param.View, this.view);
                this.invView.set(view).inv();
                this.setParam((Filter3.Parameter)Param.InvView, this.invView);
            }
            catch (RuntimeException e) {
                logger.debug(e);
            }
        }
    }

    public void setZfarK(float zfar, float k) {
        this.zFarK.set(zfar, k);
        this.setParam((Filter3.Parameter)Param.ZfarK, this.zFarK);
    }

    public void setTexture1(Texture tex) {
        this.texture1 = tex;
        this.setParam((Filter3.Parameter)Param.Texture1, 1);
    }

    public void setDepthTexture(Texture tex) {
        this.setTexture1(tex);
    }

    public void setTexture2(Texture tex) {
        this.texture2 = tex;
        this.setParam((Filter3.Parameter)Param.Texture2, 2);
    }

    public void setTexture3(Texture tex) {
        this.texture3 = tex;
        this.setParam((Filter3.Parameter)Param.Texture3, 3);
    }

    @Override
    public void rebind() {
        this.setParams((Filter3.Parameter)Param.Texture0, 0);
        this.setParams((Filter3.Parameter)Param.Texture1, 1);
        this.setParams((Filter3.Parameter)Param.Texture2, 2);
        this.setParams((Filter3.Parameter)Param.Texture3, 3);
        this.setParams((Filter3.Parameter)Param.ZfarK, this.zFarK);
        this.setParams((Filter3.Parameter)Param.FrustumCorners, this.frustumCorners);
        this.setParams((Filter3.Parameter)Param.Combined, this.combined);
        this.setParams((Filter3.Parameter)Param.Projection, this.projection);
        this.setParams((Filter3.Parameter)Param.InvProjection, this.invProjection);
        this.setParams((Filter3.Parameter)Param.View, this.view);
        this.setParams((Filter3.Parameter)Param.InvView, this.invView);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        if (this.inputTexture != null) {
            this.inputTexture.bind(0);
        }
        if (this.texture1 != null) {
            this.texture1.bind(1);
        }
        if (this.texture2 != null) {
            this.texture2.bind(2);
        }
        if (this.texture3 != null) {
            this.texture3.bind(3);
        }
    }

    public static enum Param implements Filter3.Parameter
    {
        Texture0("u_texture0", 0),
        Texture1("u_texture1", 0),
        Texture2("u_texture2", 0),
        Texture3("u_texture3", 0),
        Viewport("u_viewport", 2),
        ZfarK("u_zfark", 2),
        Projection("u_projection", 16),
        InvProjection("u_invProjection", 16),
        View("u_view", 16),
        InvView("u_invView", 16),
        Combined("u_modelView", 16),
        FrustumCorners("u_frustumCorners", 16);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

