/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class SurfaceGenFilter
extends Filter<SurfaceGenFilter> {
    private Texture lut;
    private Texture emissive;
    float lutHueShift = 0.0f;
    float lutSaturation = 1.0f;

    public SurfaceGenFilter(boolean normalMap, boolean emissiveMap) {
        super(ShaderLoader.fromFile("screenspace", "surfacegen", (normalMap ? "#define normalMapFlag\n" : "") + (emissiveMap ? "#define emissiveMapFlag\n" : "")));
        this.rebind();
    }

    public void setLutTexture(Texture lut) {
        this.lut = lut;
        this.setParam((Filter.Parameter)Param.TextureLut, 1);
    }

    public void setEmissiveTexture(Texture emissive) {
        this.emissive = emissive;
        this.setParam((Filter.Parameter)Param.TextureEmissive, 2);
    }

    public void setLutHueShift(float hs) {
        this.lutHueShift = hs;
        this.setParam((Filter.Parameter)Param.LutHueShift, this.lutHueShift);
    }

    public void setLutSaturation(float hs) {
        this.lutSaturation = hs;
        this.setParam((Filter.Parameter)Param.LutSaturation, this.lutSaturation);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.TextureLut, 1);
        if (this.emissive != null) {
            this.setParams((Filter.Parameter)Param.TextureEmissive, 2);
        }
        this.setParams((Filter.Parameter)Param.LutSaturation, this.lutSaturation);
        this.setParams((Filter.Parameter)Param.LutHueShift, this.lutHueShift);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        if (this.inputTexture != null) {
            this.inputTexture.bind(0);
        }
        if (this.lut != null) {
            this.lut.bind(1);
        }
        if (this.emissive != null) {
            this.emissive.bind(2);
        }
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        TextureLut("u_texture1", 0),
        TextureEmissive("u_texture2", 0),
        LutSaturation("u_lutSaturation", 0),
        LutHueShift("u_lutHueShift", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

