/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public final class ThresholdFilter
extends Filter<ThresholdFilter> {
    private float threshold = 0.0f;

    public ThresholdFilter() {
        super(ShaderLoader.fromFile("screenspace", "threshold"));
        this.rebind();
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
        this.setParam((Filter.Parameter)Param.Threshold, threshold);
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParam((Filter.Parameter)Param.Threshold, this.threshold);
        this.endParams();
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        Threshold("u_threshold", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int elementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = elementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

